/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.form;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.jbpm.formapi.shared.form.AbstractBaseFormDefinitionService;
import org.jbpm.formapi.shared.form.FormDefinitionService;
import org.jbpm.formapi.shared.form.FormServiceException;
import org.jbpm.formapi.shared.task.TaskRef;
import org.jbpm.formbuilder.server.file.FSFileService;
import org.jbpm.formbuilder.server.file.FileException;
import org.jbpm.model.formapi.shared.api.FormItemRepresentation;
import org.jbpm.model.formapi.shared.api.FormRepresentation;
import org.jbpm.model.formapi.shared.form.FormEncodingFactory;
import org.jbpm.model.formapi.shared.form.FormRepresentationDecoder;
import org.jbpm.model.formapi.shared.form.FormRepresentationEncoder;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSFormDefinitionService
extends AbstractBaseFormDefinitionService
implements FormDefinitionService,
InitializingBean {
    private String baseUrl;
    private FSFileService fileService;
    private String fileSeparator = System.getProperty("file.separator");

    public List<FormRepresentation> getForms(String pkgName) throws FormServiceException {
        List<String> loadFilesByType;
        ArrayList<FormRepresentation> forms = new ArrayList<FormRepresentation>();
        try {
            loadFilesByType = this.fileService.loadFilesByType(pkgName, "formdef");
        }
        catch (FileException ex) {
            throw new FormServiceException(ex.getMessage(), (Throwable)ex);
        }
        for (String assetId : loadFilesByType) {
            if (!this.isFormName(assetId)) continue;
            FormRepresentation form = this.getForm(pkgName, assetId.replace(".formdef", "").replace(this.baseUrl + this.fileSeparator + pkgName, ""));
            forms.add(form);
        }
        return forms;
    }

    public Map<String, FormItemRepresentation> getFormItems(String pkgName) throws FormServiceException {
        try {
            HashMap<String, FormItemRepresentation> items = new HashMap<String, FormItemRepresentation>();
            List<String> loadFilesByType = this.fileService.loadFilesByType(pkgName, "json");
            for (String assetId : loadFilesByType) {
                if (!this.isItemName(assetId)) continue;
                FormItemRepresentation item = this.getFormItem(pkgName, assetId.replace(".json", ""));
                items.put(assetId, item);
            }
            return items;
        }
        catch (Exception ex) {
            throw new FormServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public String saveForm(String pkgName, FormRepresentation form) throws FormServiceException {
        String finalUrl = this.baseUrl + this.fileSeparator + pkgName + this.fileSeparator + form.getName() + ".formdef";
        FormRepresentationEncoder encoder = FormEncodingFactory.getEncoder();
        try {
            String encoded = encoder.encode(form);
            File file = new File(finalUrl);
            FileUtils.writeStringToFile((File)file, (String)encoded);
        }
        catch (Exception ex) {
            throw new FormServiceException(ex.getMessage(), (Throwable)ex);
        }
        return form.getName();
    }

    public String saveFormItem(String pkgName, String formItemName, FormItemRepresentation formItem) throws FormServiceException {
        StringBuilder builder = new StringBuilder();
        this.updateItemName(formItemName, builder);
        String finalUrl = this.baseUrl + this.fileSeparator + pkgName + this.fileSeparator + builder.toString() + ".json";
        FormRepresentationEncoder encoder = FormEncodingFactory.getEncoder();
        try {
            FileUtils.writeStringToFile((File)new File(finalUrl), (String)encoder.encode(formItem));
        }
        catch (Exception ex) {
            throw new FormServiceException(ex.getMessage(), (Throwable)ex);
        }
        return formItemName;
    }

    public void deleteForm(String pkgName, String formId) throws FormServiceException {
        String deleteUrl = this.baseUrl + this.fileSeparator + pkgName + this.fileSeparator + formId + ".formdef";
        FileUtils.deleteQuietly((File)new File(deleteUrl));
    }

    public void deleteForm(String formUrl) throws FormServiceException {
        FileUtils.deleteQuietly((File)new File(formUrl));
    }

    public void deleteFormItem(String pkgName, String formItemId) throws FormServiceException {
        if (formItemId != null && !"".equals(formItemId)) {
            String deleteUrl = this.baseUrl + this.fileSeparator + pkgName + this.fileSeparator + formItemId + ".json";
            FileUtils.deleteQuietly((File)new File(deleteUrl));
        }
    }

    public void deleteFormItem(String itemUrl) throws FormServiceException {
        FileUtils.deleteQuietly((File)new File(itemUrl));
    }

    public FormRepresentation getForm(String pkgName, String formId) throws FormServiceException {
        FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
        File file = new File(this.baseUrl + this.fileSeparator + pkgName + this.fileSeparator + formId + ".formdef");
        try {
            String json = FileUtils.readFileToString((File)file);
            return decoder.decode(json);
        }
        catch (Exception ex) {
            throw new FormServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public FormRepresentation getFormByUUID(String packageName, String uuid) throws FormServiceException {
        throw new UnsupportedOperationException("Not supported in FS implementation.");
    }

    public FormItemRepresentation getFormItem(String pkgName, String formItemId) throws FormServiceException {
        if (formItemId != null && !"".equals(formItemId)) {
            try {
                FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
                String getUrl = this.baseUrl + this.fileSeparator + pkgName + "." + formItemId + ".json";
                String json = FileUtils.readFileToString((File)new File(getUrl));
                return decoder.decodeItem(json);
            }
            catch (Exception ex) {
                throw new FormServiceException(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    public FormRepresentation getAssociatedForm(String pkgName, TaskRef task) throws FormServiceException {
        List<FormRepresentation> forms = this.getForms(pkgName);
        FormRepresentation retval = null;
        for (FormRepresentation form : forms) {
            if (form.getTaskId() == null || !form.getTaskId().equals(task.getTaskId())) continue;
            retval = form;
            break;
        }
        return retval;
    }

    public void saveTemplate(String packageName, String templateName, String content) throws FormServiceException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void afterPropertiesSet() throws Exception {
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public FSFileService getFileService() {
        return this.fileService;
    }

    public void setFileService(FSFileService fileService) {
        this.fileService = fileService;
    }
}

