/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.settings;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.jbpm.formbuilder.server.settings.SettingsService;
import org.jbpm.model.formapi.client.Settings;

public class DBSettingsService
implements SettingsService {
    private EntityManagerFactory emf;

    public DBSettingsService() {
        if (this.emf == null) {
            this.emf = Persistence.createEntityManagerFactory((String)"form-builder");
        }
    }

    public Settings getSettingsByUserId(String userName) {
        EntityManager em = this.emf.createEntityManager();
        Query query = em.createNamedQuery("GetSettingsByUser");
        query.setParameter("userId", (Object)userName);
        Settings settings = null;
        try {
            settings = (Settings)query.getSingleResult();
        }
        catch (NoResultException ex) {
            System.out.println("Creating Settings for user =" + userName);
            settings = new Settings(userName);
            em.getTransaction().begin();
            em.persist((Object)settings);
            em.getTransaction().commit();
        }
        em.close();
        return settings;
    }

    public void applySettings(Settings settings, String userName) {
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.merge((Object)settings);
        em.getTransaction().commit();
        em.close();
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }
}

