/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.settings;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.jbpm.formbuilder.server.settings.SettingsService;
import org.jbpm.model.formapi.client.Settings;

public class JTADBSettingsService
implements SettingsService {
    private EntityManagerFactory emf;

    public JTADBSettingsService() {
        if (this.emf == null) {
            try {
                InitialContext ctx = new InitialContext();
                this.emf = (EntityManagerFactory)ctx.lookup("java:jboss/myEntityManagerFactory");
            }
            catch (NamingException ex) {
                Logger.getLogger(JTADBSettingsService.class.getName()).log(Level.SEVERE, null, ex);
                ex.printStackTrace();
            }
        }
    }

    public Settings getSettingsByUserId(String userName) {
        EntityManager em = this.emf.createEntityManager();
        Query query = em.createNamedQuery("GetSettingsByUser");
        query.setParameter("userId", (Object)userName);
        Settings settings = null;
        try {
            settings = (Settings)query.getSingleResult();
        }
        catch (NoResultException ex) {
            try {
                settings = new Settings(userName);
                em.persist((Object)settings);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        em.close();
        return settings;
    }

    public void applySettings(Settings settings, String userName) {
        EntityManager em = this.emf.createEntityManager();
        try {
            em.merge((Object)settings);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        em.close();
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }
}

