/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.BPMN2ProcessFactory;
import org.drools.compiler.BPMN2ProcessProvider;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.definition.process.Process;
import org.drools.io.Resource;
import org.drools.io.impl.ByteArrayResource;
import org.drools.xml.SemanticModule;
import org.jbpm.formapi.shared.task.TaskDefinitionService;
import org.jbpm.formapi.shared.task.TaskRef;
import org.jbpm.formapi.shared.task.TaskServiceException;
import org.jbpm.formbuilder.server.task.TaskDefinitionsSemanticModule;
import org.jbpm.formbuilder.server.task.TaskRepoHelper;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSTaskDefinitionService
implements TaskDefinitionService,
InitializingBean {
    private final TaskRepoHelper repo = new TaskRepoHelper();
    private final TaskDefinitionsSemanticModule module = new TaskDefinitionsSemanticModule(this.repo);
    private final BPMN2ProcessProvider provider = new BPMN2ProcessProvider(){

        public void configurePackageBuilder(PackageBuilder packageBuilder) {
            PackageBuilderConfiguration conf = packageBuilder.getPackageBuilderConfiguration();
            if (conf.getSemanticModules().getSemanticModule("http://www.jboss.org/jbpm-form-builder") == null) {
                conf.addSemanticModule((SemanticModule)FSTaskDefinitionService.this.module);
            }
        }
    };
    private String baseUrl;
    private String fileSeparator = System.getProperty("file.separator");

    public List<TaskRef> query(String pkgName, String filter) throws TaskServiceException {
        ArrayList<TaskRef> tasks = new ArrayList<TaskRef>();
        Collection listFiles = FileUtils.listFiles((File)new File(this.baseUrl + this.fileSeparator + pkgName), (String[])new String[]{"bpmn2", "rf"}, (boolean)true);
        for (File key : listFiles) {
            String assetId = key.getName();
            if (!assetId.endsWith(ResourceType.BPMN2.getDefaultExtension()) && !assetId.endsWith(ResourceType.DRF.getDefaultExtension()) && !assetId.endsWith("bpmn2")) continue;
            try {
                List<TaskRef> processTasks;
                String content = this.getTaskDefinitionContent(pkgName, assetId);
                if (content == null || "".equals(content) || (processTasks = this.getProcessTasks(content, assetId)) == null) continue;
                for (TaskRef ref : processTasks) {
                    if (filter == null || "".equals(filter)) {
                        tasks.add(ref);
                        continue;
                    }
                    if (!ref.getProcessId().contains(assetId) && !ref.getTaskName().contains(filter)) continue;
                    tasks.add(ref);
                }
            }
            catch (IOException ex) {
                throw new TaskServiceException(ex.getMessage(), (Throwable)ex);
            }
        }
        return tasks;
    }

    private String getTaskDefinitionContent(String pkgName, String itemName) throws IOException {
        if (itemName != null && !"".equals(itemName)) {
            String getUrl = this.baseUrl + this.fileSeparator + pkgName + this.fileSeparator + itemName;
            return FileUtils.readFileToString((File)new File(getUrl));
        }
        return "";
    }

    public List<TaskRef> getTasksByName(String pkgName, String processName, String taskName) throws TaskServiceException {
        ArrayList<TaskRef> retval = new ArrayList<TaskRef>();
        try {
            File processFile = this.getProcessById(pkgName, processName);
            String processContent = FileUtils.readFileToString((File)processFile);
            List<TaskRef> tasks = this.getProcessTasks(processContent, "any.bpmn2");
            for (TaskRef task : tasks) {
                if (task.getTaskId() == null || !task.getTaskId().equals(taskName)) continue;
                retval.add(task);
            }
        }
        catch (IOException ex) {
            throw new TaskServiceException(ex.getMessage(), (Throwable)ex);
        }
        return retval;
    }

    public File getProcessById(String pkgName, String processName) throws TaskServiceException {
        Collection listFiles = FileUtils.listFiles((File)new File(this.baseUrl + this.fileSeparator + pkgName), (String[])new String[]{"bpmn2", "rf"}, (boolean)true);
        for (File file : listFiles) {
            try {
                String processContent = FileUtils.readFileToString((File)file);
                KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
                kbuilder.add((Resource)new ByteArrayResource(processContent.getBytes()), ResourceType.BPMN2);
                if (!kbuilder.hasErrors()) {
                    KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
                    kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
                    Collection processes = kbase.getProcesses();
                    for (Process process : processes) {
                        if (!process.getId().equals(processName)) continue;
                        return file;
                    }
                    continue;
                }
                throw new IllegalStateException(" Knowledge Could Not be Parsed " + kbuilder.getErrors());
            }
            catch (Exception ex) {
                throw new TaskServiceException(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    public TaskRef getTaskByUUID(String pkgName, String userTask, String uuid) throws TaskServiceException {
        throw new UnsupportedOperationException("Not supported for FS implementation.");
    }

    public String getContainingPackage(String uuid) throws TaskServiceException {
        throw new UnsupportedOperationException("Not supported yet for FS implementation.");
    }

    public TaskRef getBPMN2Task(String bpmn2ProcessContent, String processName, String userTask) throws TaskServiceException {
        TaskRef retval = null;
        List<TaskRef> tasks = this.getProcessTasks(bpmn2ProcessContent, processName);
        if (tasks != null) {
            for (TaskRef task : tasks) {
                if (!task.getTaskName().equals(userTask)) continue;
                retval = task;
                break;
            }
        }
        return retval;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected List<TaskRef> getProcessTasks(String bpmn2Content, String processName) {
        if (bpmn2Content == null || "".equals(bpmn2Content)) {
            return new ArrayList<TaskRef>();
        }
        if (BPMN2ProcessFactory.getBPMN2ProcessProvider() != this.provider) {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)this.provider);
        }
        this.repo.clear();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        boolean isBPMN = processName.toLowerCase().endsWith("bpmn");
        boolean isBPMN2 = processName.toLowerCase().endsWith("bpmn2");
        ResourceType type = isBPMN || isBPMN2 ? ResourceType.BPMN2 : ResourceType.DRF;
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), type);
        if (!kbuilder.hasErrors()) {
            return new ArrayList<TaskRef>(this.repo.getTasks());
        }
        return new ArrayList<TaskRef>();
    }
}

