/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.task;

import java.util.ArrayList;
import java.util.Map;
import org.jbpm.bpmn2.xml.UserTaskHandler;
import org.jbpm.formapi.shared.task.TaskPropertyRef;
import org.jbpm.formapi.shared.task.TaskRef;
import org.jbpm.formbuilder.server.task.TaskRepoHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTaskGetInformationHandler
extends UserTaskHandler {
    private final TaskRepoHelper taskRepository;

    public HumanTaskGetInformationHandler(TaskRepoHelper taskRepository) {
        this.taskRepository = taskRepository;
    }

    protected void readIoSpecification(Node xmlNode, Map<String, String> dataInputs, Map<String, String> dataOutputs) {
        dataInputs.clear();
        dataOutputs.clear();
        Node subNode = xmlNode.getFirstChild();
        while (subNode instanceof Element) {
            String id;
            String subNodeName = subNode.getNodeName();
            if ("dataInput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String inputName = ((Element)subNode).getAttribute("name");
                dataInputs.put(id, inputName);
            }
            if ("dataOutput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String outputName = ((Element)subNode).getAttribute("name");
                dataOutputs.put(id, outputName);
            }
            subNode = subNode.getNextSibling();
        }
        NamedNodeMap map = xmlNode.getParentNode().getAttributes();
        Node nodeName = map.getNamedItem("name");
        String name = nodeName.getNodeValue();
        TaskRef task = new TaskRef();
        task.setTaskId(name);
        ArrayList<TaskPropertyRef> inputs = new ArrayList<TaskPropertyRef>(dataInputs.size());
        for (Map.Entry<String, String> in : dataInputs.entrySet()) {
            TaskPropertyRef prop = new TaskPropertyRef();
            prop.setName(in.getValue());
            prop.setSourceExpresion(in.getValue());
            inputs.add(prop);
        }
        task.setInputs(inputs);
        ArrayList<TaskPropertyRef> outputs = new ArrayList<TaskPropertyRef>(dataOutputs.size());
        for (Map.Entry<String, String> out : dataOutputs.entrySet()) {
            TaskPropertyRef prop = new TaskPropertyRef();
            prop.setName(out.getValue());
            prop.setSourceExpresion(out.getValue());
            outputs.add(prop);
        }
        task.setOutputs(outputs);
        this.taskRepository.addTask(task);
    }
}

