/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.services.model.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.services.model.FormItemRepresentation;
import org.jbpm.form.builder.services.model.forms.FormEncodingException;
import org.jbpm.form.builder.services.model.forms.FormEncodingFactory;
import org.jbpm.form.builder.services.model.forms.FormRepresentationDecoder;

public class TableRepresentation
extends FormItemRepresentation {
    private final List<List<FormItemRepresentation>> elements = new ArrayList<List<FormItemRepresentation>>();
    private Integer rows = 0;
    private Integer columns = 0;
    private Integer borderWidth;
    private Integer cellPadding;
    private Integer cellSpacing;

    public TableRepresentation() {
        super("table");
    }

    public void setRows(Integer rows) {
        this.rows = rows;
        this.checkRoom();
    }

    public void setColumns(Integer columns) {
        this.columns = columns;
        this.checkRoom();
    }

    private void checkRoom() {
        if (this.rows > 0 && this.columns > 0) {
            for (int index = 0; index < this.rows; ++index) {
                ArrayList<Object> row = new ArrayList<Object>(this.columns);
                for (int subIndex = 0; subIndex < this.columns; ++subIndex) {
                    row.add(null);
                }
                this.elements.add(row);
            }
        }
    }

    public Integer getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(Integer borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Integer getCellPadding() {
        return this.cellPadding;
    }

    public void setCellPadding(Integer cellPadding) {
        this.cellPadding = cellPadding;
    }

    public Integer getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(Integer cellSpacing) {
        this.cellSpacing = cellSpacing;
    }

    public List<List<FormItemRepresentation>> getElements() {
        return this.elements;
    }

    public void setElement(int rowNumber, int colNumber, FormItemRepresentation subRep) {
        while (this.elements.size() <= rowNumber) {
            this.elements.add(new ArrayList());
            this.rows = this.elements.size();
        }
        List<FormItemRepresentation> row = this.elements.get(rowNumber);
        while (row.size() <= colNumber) {
            row.add(null);
            this.columns = row.size();
        }
        row.set(colNumber, subRep);
        this.elements.set(rowNumber, row);
    }

    public Integer getRows() {
        return this.rows;
    }

    public Integer getColumns() {
        return this.columns;
    }

    @Override
    public Map<String, Object> getDataMap() {
        Map<String, Object> data = super.getDataMap();
        data.put("borderWidth", this.borderWidth);
        data.put("cellPadding", this.cellPadding);
        data.put("cellSpacing", this.cellSpacing);
        data.put("rows", this.rows);
        data.put("columns", this.columns);
        ArrayList mapElements = new ArrayList();
        if (this.elements != null) {
            for (List<FormItemRepresentation> row : this.elements) {
                ArrayList<Map<String, Object>> mapRow = null;
                if (row != null) {
                    mapRow = new ArrayList<Map<String, Object>>();
                    for (FormItemRepresentation cell : row) {
                        mapRow.add(cell == null ? null : cell.getDataMap());
                    }
                }
                mapElements.add(mapRow);
            }
        }
        data.put("elements", mapElements);
        return data;
    }

    @Override
    public void setDataMap(Map<String, Object> data) throws FormEncodingException {
        super.setDataMap(data);
        this.borderWidth = data.get("borderWidth") == null ? null : Integer.valueOf(((Number)data.get("borderWidth")).intValue());
        this.cellPadding = data.get("cellPadding") == null ? null : Integer.valueOf(((Number)data.get("cellPadding")).intValue());
        this.cellSpacing = data.get("cellSpacing") == null ? null : Integer.valueOf(((Number)data.get("cellSpacing")).intValue());
        this.columns = data.get("columns") == null ? null : Integer.valueOf(((Number)data.get("columns")).intValue());
        this.rows = data.get("rows") == null ? null : Integer.valueOf(((Number)data.get("rows")).intValue());
        this.elements.clear();
        FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
        List mapElements = (List)data.get("elements");
        if (mapElements != null) {
            for (List mapRow : mapElements) {
                ArrayList<FormItemRepresentation> row = new ArrayList<FormItemRepresentation>();
                if (mapRow != null) {
                    for (Map mapCell : mapRow) {
                        row.add((FormItemRepresentation)decoder.decode(mapCell));
                    }
                }
                this.elements.add(row);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals;
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TableRepresentation)) {
            return false;
        }
        TableRepresentation other = (TableRepresentation)obj;
        boolean bl = equals = this.rows == null && other.rows == null || this.rows != null && this.rows.equals(other.rows);
        if (!equals) {
            return equals;
        }
        boolean bl2 = equals = this.columns == null && other.columns == null || this.columns != null && this.columns.equals(other.columns);
        if (!equals) {
            return equals;
        }
        boolean bl3 = equals = this.borderWidth == null && other.borderWidth == null || this.borderWidth != null && this.borderWidth.equals(other.borderWidth);
        if (!equals) {
            return equals;
        }
        boolean bl4 = equals = this.cellPadding == null && other.cellPadding == null || this.cellPadding != null && this.cellPadding.equals(other.cellPadding);
        if (!equals) {
            return equals;
        }
        boolean bl5 = equals = this.cellSpacing == null && other.cellSpacing == null || this.cellSpacing != null && this.cellSpacing.equals(other.cellSpacing);
        if (!equals) {
            return equals;
        }
        equals = this.elements == null && other.elements == null || this.elements != null && ((Object)this.elements).equals(other.elements);
        return equals;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        int aux = this.rows == null ? 0 : this.rows.hashCode();
        result = 37 * result + aux;
        aux = this.columns == null ? 0 : this.columns.hashCode();
        result = 37 * result + aux;
        aux = this.borderWidth == null ? 0 : this.borderWidth.hashCode();
        result = 37 * result + aux;
        aux = this.cellPadding == null ? 0 : this.cellPadding.hashCode();
        result = 37 * result + aux;
        aux = this.cellSpacing == null ? 0 : this.cellSpacing.hashCode();
        result = 37 * result + aux;
        aux = this.elements == null ? 0 : ((Object)this.elements).hashCode();
        result = 37 * result + aux;
        return result;
    }
}

