/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.services.impl.db;

import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.jbpm.form.builder.services.api.SettingsService;
import org.jbpm.form.builder.services.model.Settings;

public class DBSettingsService
implements SettingsService {
    @Inject
    private EntityManager em;

    @Override
    public Settings getSettingsByUserId(String userName) {
        Query query = this.em.createNamedQuery("GetSettingsByUser");
        query.setParameter("userId", (Object)userName);
        Settings settings = null;
        try {
            settings = (Settings)query.getSingleResult();
        }
        catch (NoResultException ex) {
            try {
                settings = new Settings(userName);
                this.em.persist((Object)settings);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        return settings;
    }

    @Override
    public void applySettings(Settings settings, String userName) {
        try {
            this.em.merge((Object)settings);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> getSettingsByUserIdGWT(String userName) {
        Settings settings = this.getSettingsByUserId(userName);
        if (settings == null) {
            return null;
        }
        return settings.getDataMap();
    }

    @Override
    public void applySettingsGWT(Map<String, Object> settingsDto, String userName) {
        Settings settings = new Settings();
        settings.setDataMap(settingsDto);
        this.applySettings(settings, userName);
    }
}

