/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server;

import java.io.IOException;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.server.FormProcessingFacade;
import org.jboss.bpm.console.server.integration.ManagementFactory;
import org.jboss.bpm.console.server.integration.ProcessManagement;
import org.jboss.bpm.console.server.integration.TaskManagement;
import org.jboss.bpm.console.server.plugin.FormAuthorityRef;
import org.jboss.bpm.console.server.plugin.FormDispatcherPlugin;
import org.jboss.bpm.console.server.plugin.PluginMgr;
import org.jboss.bpm.console.server.util.ProjectName;
import org.jboss.bpm.console.server.util.RsComment;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="form")
@RsComment(title="Form Processing", description="Web based form processing", project={ProjectName.JBPM})
public class FormProcessingFacade {
    private static final Logger log = LoggerFactory.getLogger(FormProcessingFacade.class);
    private FormDispatcherPlugin formPlugin;
    private ProcessManagement processManagement;
    private TaskManagement taskManagement;
    private static final String SUCCESSFULLY_PROCESSED_INPUT = "<div style='font-family:sans-serif; padding:10px;'><h3>Successfully processed input</h3><p/>You can now close this window.</div>";

    private TaskManagement getTaskManagement() {
        if (null == this.taskManagement) {
            ManagementFactory factory = ManagementFactory.newInstance();
            this.taskManagement = factory.createTaskManagement();
            log.debug("Using ManagementFactory impl:" + factory.getClass().getName());
        }
        return this.taskManagement;
    }

    private ProcessManagement getProcessManagement() {
        if (null == this.processManagement) {
            ManagementFactory factory = ManagementFactory.newInstance();
            this.processManagement = factory.createProcessManagement();
            log.debug("Using ManagementFactory impl:" + factory.getClass().getName());
        }
        return this.processManagement;
    }

    private FormDispatcherPlugin getFormDispatcherPlugin() {
        if (null == this.formPlugin) {
            this.formPlugin = (FormDispatcherPlugin)PluginMgr.load(FormDispatcherPlugin.class);
            log.debug("Using FormDispatcherPlugin impl:" + this.formPlugin);
        }
        return this.formPlugin;
    }

    @GET
    @Path(value="task/{id}/render")
    @Produces(value={"text/html"})
    public Response renderTaskUI(@PathParam(value="id") String taskId) {
        return this.provideForm(new FormAuthorityRef(taskId));
    }

    @GET
    @Path(value="process/{id}/render")
    @Produces(value={"text/html"})
    public Response renderProcessUI(@PathParam(value="id") String definitionId) {
        return this.provideForm(new FormAuthorityRef(definitionId, FormAuthorityRef.Type.PROCESS));
    }

    @POST
    @Path(value="task/{id}/complete")
    @Produces(value={"text/html"})
    @Consumes(value={"multipart/form-data"})
    public Response closeTaskWithUI(@Context HttpServletRequest request, @PathParam(value="id") String taskId, MultipartFormDataInput payload) {
        FieldMapping mapping = this.createFieldMapping(payload);
        String username = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : null;
        String outcomeDirective = (String)mapping.directives.get("outcome");
        if (outcomeDirective != null) {
            this.getTaskManagement().completeTask(Long.valueOf(taskId).longValue(), outcomeDirective, mapping.processVars, username);
        } else {
            this.getTaskManagement().completeTask(Long.valueOf(taskId).longValue(), mapping.processVars, username);
        }
        return Response.ok((Object)SUCCESSFULLY_PROCESSED_INPUT).build();
    }

    @POST
    @Path(value="process/{id}/complete")
    @Produces(value={"text/html"})
    @Consumes(value={"multipart/form-data"})
    public Response startProcessWithUI(@Context HttpServletRequest request, @PathParam(value="id") String definitionId, MultipartFormDataInput payload) {
        FieldMapping mapping = this.createFieldMapping(payload);
        ProcessInstanceRef instance = this.getProcessManagement().newInstance(definitionId, mapping.processVars);
        return Response.ok((Object)SUCCESSFULLY_PROCESSED_INPUT).build();
    }

    private Response provideForm(FormAuthorityRef authorityRef) {
        DataHandler dh = this.getFormDispatcherPlugin().provideForm(authorityRef);
        if (null == dh) {
            throw new RuntimeException("No UI associated with " + authorityRef.getType() + " " + authorityRef.getReferenceId());
        }
        return Response.ok((Object)dh.getDataSource()).type("text/html").build();
    }

    private FieldMapping createFieldMapping(MultipartFormDataInput payload) {
        FieldMapping mapping = new FieldMapping(this, null);
        Map formData = payload.getFormData();
        for (String partName : formData.keySet()) {
            InputPart part = (InputPart)formData.get(partName);
            MediaType mediaType = part.getMediaType();
            String mType = mediaType.getType();
            String mSubtype = mediaType.getSubtype();
            try {
                if ("text".equals(mType) && "plain".equals(mSubtype)) {
                    if (mapping.isReserved(partName)) {
                        mapping.directives.put(partName, part.getBodyAsString());
                        continue;
                    }
                    mapping.processVars.put(partName, part.getBodyAsString());
                    continue;
                }
                byte[] data = part.getBodyAsString().getBytes();
                DataHandler dh = new DataHandler((DataSource)new /* Unavailable Anonymous Inner Class!! */);
                mapping.processVars.put(partName, dh);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return mapping;
    }
}

