/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.jboss.bpm.console.server.util.BufferedResponseWrapper;

public class GWTJsonFilter
implements Filter {
    public FilterConfig filterConfig;
    private static final String COLLECTION_PREFIX = "{\"wrapper\":";
    private static final String COLLECTION_SUFFIX = "}";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isSOPCallback = false;
        if (request.getParameter("callback") != null) {
            isSOPCallback = true;
        }
        ServletOutputStream out = response.getOutputStream();
        BufferedResponseWrapper wrapper = new BufferedResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)wrapper);
        String contentType = response.getContentType() != null ? response.getContentType() : "application/octet-stream";
        boolean isJSONEncoding = contentType.equals("application/json");
        StringBuffer sb = null;
        if (isJSONEncoding) {
            String payload = new String(wrapper.getData());
            String gwtextFriendly = this.trimPayload(payload);
            sb = new StringBuffer();
            if (isSOPCallback) {
                sb.append(request.getParameter("callback"));
                sb.append("(");
            }
            sb.append(gwtextFriendly);
            if (isSOPCallback) {
                sb.append(");");
            }
        }
        if (sb != null) {
            out.write(sb.toString().getBytes());
        } else {
            out.write(wrapper.getData());
        }
        out.flush();
        out.close();
    }

    private String trimPayload(String payload) {
        String s = payload;
        if (s.startsWith(COLLECTION_PREFIX)) {
            s = payload.substring(COLLECTION_PREFIX.length(), payload.lastIndexOf(COLLECTION_SUFFIX));
        }
        return s;
    }

    public void destroy() {
    }
}

