/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.tomcat;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.users.AbstractRole;
import org.apache.catalina.users.AbstractUser;
import org.apache.catalina.valves.ValveBase;

public class JACCValve
extends ValveBase {
    private static Map<String, Subject> localCache = Collections.synchronizedMap(new HashMap());
    private static ThreadLocal<Subject> subject = new ThreadLocal();

    private static Subject get() {
        return subject.get();
    }

    public JACCValve() {
        try {
            PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)new PolicyContextHandler(){

                public boolean supports(String key) throws PolicyContextException {
                    return "javax.security.auth.Subject.container".equals(key);
                }

                public String[] getKeys() throws PolicyContextException {
                    return new String[]{"javax.security.auth.Subject.container"};
                }

                public Object getContext(String key, Object data) throws PolicyContextException {
                    return JACCValve.get();
                }
            }, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        String uri = request.getRequestURI();
        if (uri.endsWith("sid/invalidate")) {
            localCache.remove(request.getSession().getId());
        } else {
            subject.set(localCache.get(request.getSession().getId()));
        }
        this.getNext().invoke(request, response);
        if (uri.endsWith("user/roles") && request.getUserPrincipal() != null) {
            try {
                this.initJACC(request.getSession().getId(), request.getUserPrincipal());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        subject.set(null);
    }

    private void initJACC(String sessionid, Principal principal) {
        HashSet<Object> principals = new HashSet<Object>();
        principals.add(principal);
        Iterator it = ((AbstractUser)principal).getRoles();
        if (it != null) {
            Group group = new Group(){
                private List<Principal> members = new ArrayList<Principal>();

                public String getName() {
                    return "Roles";
                }

                public boolean removeMember(Principal user) {
                    return this.members.remove(user);
                }

                public Enumeration<? extends Principal> members() {
                    return Collections.enumeration(this.members);
                }

                public boolean isMember(Principal member) {
                    return this.members.contains(member);
                }

                public boolean addMember(Principal user) {
                    return this.members.add(user);
                }
            };
            while (it.hasNext()) {
                AbstractRole user = (AbstractRole)it.next();
                group.addMember((Principal)user);
            }
            principals.add(group);
        }
        Subject s = new Subject(false, principals, Collections.EMPTY_SET, Collections.EMPTY_SET);
        localCache.put(sessionid, s);
    }
}

