/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.LayoutFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.TabbedPanelRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.form.items.FlowLayoutFormItem;
import org.jbpm.formbuilder.client.form.items.TabbedLayoutFormItem;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class TabbedLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final List<FlowLayoutFormItem> tabs = new ArrayList();
    private final List<TabLabelFormItem> titles = new ArrayList();
    private String cssClassName;
    private String tabWidth;
    private String id;
    private TabLayoutPanel panel = new MyTabLayoutPanel(this, 21.0, Style.Unit.PX);

    public TabbedLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        TabLabelFormItem tab1 = new TabLabelFormItem(this, this.getFormEffects());
        tab1.getLabel().setText("Tab 1");
        this.panel.add((Widget)new FlowLayoutFormItem(this.getFormEffects()), (Widget)tab1);
        TabLabelFormItem tab2 = new TabLabelFormItem(this, this.getFormEffects());
        tab2.getLabel().setText("Tab 2");
        this.panel.add((Widget)new FlowLayoutFormItem(this.getFormEffects()), (Widget)tab2);
        TabLabelFormItem tab3 = new TabLabelFormItem(this, this.getFormEffects());
        tab3.getLabel().setText("Tab 3");
        this.panel.add((Widget)new FlowLayoutFormItem(this.getFormEffects()), (Widget)tab3);
        this.setSize("300px", "400px");
        this.panel.setSize("300px", "400px");
        this.add((Widget)this.panel);
    }

    public TabbedLayoutFormItem() {
        this(new ArrayList());
    }

    public void replacePhantom(FBFormItem item) {
        int selectedIndex = this.panel.getSelectedIndex();
        Widget tabWidget = this.panel.getWidget(selectedIndex);
        FlowLayoutFormItem tab = (FlowLayoutFormItem)tabWidget;
        tab.replacePhantom(item);
    }

    public void add(PhantomPanel phantom, int x, int y) {
        int selectedIndex = this.panel.getSelectedIndex();
        Widget widget = this.panel.getWidget(selectedIndex);
        FlowLayoutFormItem tab = (FlowLayoutFormItem)widget;
        tab.add(phantom, x, y);
    }

    public HasWidgets getPanel() {
        return this.panel;
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("cssClassName", this.cssClassName);
        map.put("id", this.id);
        map.put("numberOfTabs", this.panel.getWidgetCount());
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        block5: {
            Integer numberOfTabs;
            block4: {
                String width;
                String height = this.extractString(asPropertiesMap.get("height"));
                if (height != null && !"".equals(height)) {
                    this.setHeight(height);
                }
                if ((width = this.extractString(asPropertiesMap.get("width"))) != null && !"".equals(width)) {
                    this.setWidth(width);
                }
                this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
                this.id = this.extractString(asPropertiesMap.get("id"));
                numberOfTabs = this.extractInt(asPropertiesMap.get("numberOfTabs"));
                if (numberOfTabs <= this.panel.getWidgetCount()) break block4;
                for (int qtyToAdd = numberOfTabs - this.panel.getWidgetCount(); qtyToAdd > 0; --qtyToAdd) {
                    TabLabelFormItem label = new TabLabelFormItem(this, this.getFormEffects());
                    FlowLayoutFormItem flow = new FlowLayoutFormItem(this.getFormEffects());
                    label.getLabel().setText("Tab " + this.panel.getWidgetCount());
                    this.panel.add((Widget)flow, (Widget)label);
                }
                break block5;
            }
            if (numberOfTabs >= this.panel.getWidgetCount()) break block5;
            while (numberOfTabs.intValue() != this.panel.getWidgetCount()) {
                this.panel.remove(this.panel.getWidgetCount() - 1);
                Integer n = numberOfTabs;
                Integer n2 = numberOfTabs = Integer.valueOf(numberOfTabs - 1);
            }
        }
    }

    public FormItemRepresentation getRepresentation() {
        TabbedPanelRepresentation trep = (TabbedPanelRepresentation)super.getRepresentation((FormItemRepresentation)new TabbedPanelRepresentation());
        trep.setCssClassName(this.cssClassName);
        trep.setId(this.id);
        for (int index = 0; index < this.titles.size(); ++index) {
            FlowLayoutFormItem tabContent = null;
            if (index < this.tabs.size()) {
                tabContent = (FlowLayoutFormItem)this.tabs.get(index);
            }
            if (tabContent == null) {
                tabContent = new FlowLayoutFormItem(this.getFormEffects());
            }
            String tabTitle = ((TabLabelFormItem)this.titles.get(index)).getLabel().getText();
            trep.putTab(index, tabTitle, tabContent.getRepresentation());
        }
        return trep;
    }

    private void populate(TabLayoutPanel panel) {
        panel.setHeight(this.getHeight());
        panel.setWidth(this.getWidth());
        panel.clear();
        for (int index = 0; index < this.titles.size() && index < this.tabs.size(); ++index) {
            FlowLayoutFormItem flow = (FlowLayoutFormItem)this.tabs.get(index);
            TabLabelFormItem label = (TabLabelFormItem)this.titles.get(index);
            if (flow == null || label == null) continue;
            FlowLayoutFormItem newFlow = (FlowLayoutFormItem)flow.cloneItem();
            if (this.cssClassName != null && !"".equals(this.cssClassName)) {
                newFlow.setStyleName(this.cssClassName);
            }
            panel.add((Widget)newFlow, (Widget)label.cloneItem());
        }
    }

    public FBFormItem cloneItem() {
        TabbedLayoutFormItem clone = new TabbedLayoutFormItem(this.getFormEffects());
        clone.id = this.id;
        clone.cssClassName = this.cssClassName;
        for (TabLabelFormItem label : this.titles) {
            clone.titles.add((TabLabelFormItem)label.cloneItem());
        }
        for (FlowLayoutFormItem flow : this.tabs) {
            clone.tabs.add((FlowLayoutFormItem)flow.cloneItem());
        }
        this.populate(clone.panel);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        MyTabLayoutPanel panel = new MyTabLayoutPanel(this, 25.0, Style.Unit.PX);
        panel.getElement().setId(this.id);
        panel.getElement().setClassName(this.cssClassName);
        for (int index = 0; index < this.titles.size() && index < this.tabs.size(); ++index) {
            FlowLayoutFormItem flow = (FlowLayoutFormItem)this.tabs.get(index);
            TabLabelFormItem label = (TabLabelFormItem)this.titles.get(index);
            if (flow == null || label == null) continue;
            Widget newFlow = flow.cloneDisplay(data);
            if (this.cssClassName != null && !"".equals(this.cssClassName)) {
                newFlow.setStyleName(this.cssClassName);
            }
            panel.add(newFlow, label.cloneDisplay(data));
        }
        super.populateActions(panel.getElement());
        return panel;
    }

    public boolean add(FBFormItem item) {
        int index = this.panel.getSelectedIndex();
        Widget widget = this.panel.getWidget(index);
        FlowLayoutFormItem tab = (FlowLayoutFormItem)widget;
        return tab.add(item);
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof TabbedPanelRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "TabbedPanelRepresentation"));
        }
        super.populate(rep);
        TabbedPanelRepresentation trep = (TabbedPanelRepresentation)rep;
        this.cssClassName = trep.getCssClassName();
        this.id = trep.getId();
        this.tabWidth = trep.getTabWidth();
        this.titles.clear();
        for (TabbedPanelRepresentation.IndexedString title : trep.getTabTitles()) {
            TabLabelFormItem label = new TabLabelFormItem(this, this.getFormEffects());
            label.getLabel().setText(title.getString());
            if (this.tabWidth != null && !"".equals(this.tabWidth)) {
                label.setWidth(this.tabWidth);
            }
            FormItemRepresentation subRep = (FormItemRepresentation)trep.getTabContents().get(title);
            FlowLayoutFormItem subItem = (FlowLayoutFormItem)FBFormItem.createItem((FormItemRepresentation)subRep);
            if (this.cssClassName != null && !"".equals(this.cssClassName)) {
                subItem.setStyleName(this.cssClassName);
            }
            this.tabs.add(subItem);
            this.titles.add(label);
        }
        this.populate(this.panel);
    }

    public int getTabForCoordinates(int x, int y) {
        for (int tabNumber = 0; tabNumber < this.panel.getWidgetCount(); ++tabNumber) {
            Widget widget = this.panel.getTabWidget(tabNumber);
            int left = widget.getAbsoluteLeft();
            int top = widget.getAbsoluteTop();
            int right = left + widget.getOffsetWidth();
            int bottom = top + widget.getOffsetHeight();
            if (x <= left || x >= right || y <= top || y >= bottom) continue;
            return tabNumber;
        }
        return this.panel.getSelectedIndex();
    }

    public FBFormItem[] removeTab(int tabNumber) {
        FBFormItem[] retval = new FBFormItem[]{(FBFormItem)this.titles.get(tabNumber), (FBFormItem)this.tabs.get(tabNumber)};
        this.titles.remove(tabNumber);
        this.tabs.remove(tabNumber);
        this.panel.remove(tabNumber);
        return retval;
    }

    public void insertTab(int tabNumber, TabLabelFormItem label, FlowLayoutFormItem panel) {
        if (label == null) {
            label = new TabLabelFormItem(this, this.getFormEffects());
            label.getLabel().setText("Tab " + (tabNumber + 1));
            if (this.tabWidth != null && !"".equals(this.tabWidth)) {
                label.setWidth(this.tabWidth);
            }
        }
        if (panel == null) {
            panel = new FlowLayoutFormItem(this.getFormEffects());
            if (this.cssClassName != null && !"".equals(this.cssClassName)) {
                panel.setStyleName(this.cssClassName);
            }
        }
        this.panel.insert((Widget)panel, (Widget)label, tabNumber);
        List nextLabels = this.titles.subList(tabNumber, this.titles.size() - 1);
        this.titles.removeAll(nextLabels);
        this.titles.add(label);
        this.titles.addAll(nextLabels);
        List nextPanels = this.tabs.subList(tabNumber, this.tabs.size() - 1);
        this.tabs.removeAll(nextPanels);
        this.tabs.add(panel);
        this.tabs.addAll(nextPanels);
    }

    static /* synthetic */ List access$000(TabbedLayoutFormItem x0) {
        return x0.titles;
    }

    static /* synthetic */ String access$102(TabbedLayoutFormItem x0, String x1) {
        x0.tabWidth = x1;
        return x0.tabWidth;
    }
}

