/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.jbpm.formapi.server.form.FormEncodingServerFactory;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formapi.shared.form.FormEncodingException;
import org.jbpm.formapi.shared.form.FormEncodingFactory;
import org.jbpm.formapi.shared.form.FormRepresentationDecoder;
import org.jbpm.formapi.shared.form.FormRepresentationEncoder;
import org.jbpm.formbuilder.server.form.GuvnorFormDefinitionService;
import org.jbpm.formbuilder.server.task.GuvnorTaskDefinitionService;
import org.jbpm.formbuilder.shared.form.FormDefinitionService;
import org.jbpm.formbuilder.shared.form.FormServiceException;
import org.jbpm.formbuilder.shared.task.TaskDefinitionService;
import org.jbpm.formbuilder.shared.task.TaskPropertyRef;
import org.jbpm.formbuilder.shared.task.TaskRef;
import org.jbpm.formbuilder.shared.task.TaskServiceException;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EmbedingServlet
extends HttpServlet {
    private static final long serialVersionUID = -5943196576708424978L;

    public void init(ServletConfig config) throws ServletException {
        FormEncodingFactory.register((FormRepresentationEncoder)FormEncodingServerFactory.getEncoder(), (FormRepresentationDecoder)FormEncodingServerFactory.getDecoder());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String profile = request.getParameter("profile");
        String usr = request.getParameter("usr");
        String pwd = request.getParameter("pwd");
        TaskDefinitionService taskService = this.createTaskService(request, usr, pwd);
        FormDefinitionService formService = this.createFormService(request, usr, pwd);
        FormRepresentationEncoder encoder = FormEncodingFactory.getEncoder();
        JsonObject json = new JsonObject();
        json.addProperty("embedded", profile);
        try {
            if (profile != null && "guvnor".equals(profile)) {
                String uuid = request.getParameter("uuid");
                String packageName = taskService.getContainingPackage(uuid);
                FormRepresentation form = formService.getFormByUUID(packageName, uuid);
                json.addProperty("uuid", uuid);
                json.addProperty("packageName", packageName);
                if (form != null) {
                    json.addProperty("formjson", encoder.encode(form));
                }
            } else {
                throw new Exception("Unknown profile for GET: " + profile);
            }
            request.setAttribute("jsonData", (Object)new Gson().toJson((JsonElement)json));
            request.getRequestDispatcher("/FormBuilder.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (TaskServiceException e) {
            response.sendError(500, "Problem getting task from guvnor");
        }
        catch (FormServiceException e) {
            response.sendError(500, "Problem reading form from guvnor");
        }
        catch (FormEncodingException e) {
            response.sendError(500, "Problem encoding form");
        }
        catch (Exception e) {
            response.sendError(500, e.getMessage());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String profile = request.getParameter("profile");
        String usr = request.getParameter("usr");
        String pwd = request.getParameter("pwd");
        TaskDefinitionService taskService = this.createTaskService(request, usr, pwd);
        FormDefinitionService formService = this.createFormService(request, usr, pwd);
        FormRepresentationEncoder encoder = FormEncodingFactory.getEncoder();
        JsonObject json = new JsonObject();
        json.addProperty("embedded", profile);
        try {
            if (profile != null && "designer".equals(profile)) {
                String userTask = request.getParameter("userTask");
                String processName = request.getParameter("processName");
                String bpmn2Process = IOUtils.toString((Reader)request.getReader());
                TaskRef task = taskService.getBPMN2Task(bpmn2Process, processName, userTask);
                if (task != null) {
                    FormRepresentation form = formService.getAssociatedForm(task.getPackageName(), task);
                    if (form != null) {
                        json.addProperty("formjson", encoder.encode(form));
                    }
                    json.add("task", (JsonElement)this.toJsonObject(task));
                    json.addProperty("packageName", task.getPackageName());
                }
            } else {
                throw new Exception("Unknown profile for POST: " + profile);
            }
            request.setAttribute("jsonData", (Object)new Gson().toJson((JsonElement)json));
            request.getRequestDispatcher("/FormBuilder.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (TaskServiceException e) {
            response.sendError(500, "Problem getting task from guvnor");
        }
        catch (FormServiceException e) {
            response.sendError(500, "Problem reading form from guvnor");
        }
        catch (FormEncodingException e) {
            response.sendError(500, "Problem encoding form");
        }
        catch (Exception e) {
            response.sendError(500, e.getMessage());
        }
    }

    protected FormDefinitionService createFormService(HttpServletRequest request, String usr, String pwd) {
        GuvnorFormDefinitionService service = (GuvnorFormDefinitionService)WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getSession().getServletContext()).getBean("guvnorFormService");
        if (usr != null && pwd != null) {
            service.setUser(usr);
            service.setPassword(pwd);
            try {
                service.afterPropertiesSet();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return service;
    }

    protected TaskDefinitionService createTaskService(HttpServletRequest request, String usr, String pwd) {
        GuvnorTaskDefinitionService service = (GuvnorTaskDefinitionService)WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getSession().getServletContext()).getBean("guvnorTaskService");
        if (usr != null && pwd != null) {
            service.setUser(usr);
            service.setPassword(pwd);
            try {
                service.afterPropertiesSet();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return service;
    }

    private JsonObject toJsonObject(TaskRef task) {
        JsonObject jsonTask = new JsonObject();
        jsonTask.addProperty("processId", task.getProcessId());
        jsonTask.addProperty("taskId", task.getTaskId());
        jsonTask.addProperty("taskName", task.getTaskName());
        JsonArray jsonInputs = new JsonArray();
        List inputs = task.getInputs();
        if (inputs != null) {
            for (TaskPropertyRef input : inputs) {
                JsonObject jsonInput = new JsonObject();
                jsonInput.addProperty("name", input.getName());
                jsonInput.addProperty("sourceExpression", input.getSourceExpresion());
                jsonInputs.add((JsonElement)jsonInput);
            }
        }
        jsonTask.add("inputs", (JsonElement)jsonInputs);
        JsonArray jsonOutputs = new JsonArray();
        List outputs = task.getOutputs();
        if (outputs != null) {
            for (TaskPropertyRef output : outputs) {
                JsonObject jsonOutput = new JsonObject();
                jsonOutput.addProperty("name", output.getName());
                jsonOutput.addProperty("sourceExpression", output.getSourceExpresion());
                jsonOutputs.add((JsonElement)jsonOutput);
            }
        }
        jsonTask.add("outputs", (JsonElement)jsonOutputs);
        JsonObject jsonMetaData = new JsonObject();
        Map metaData = task.getMetaData();
        if (metaData != null) {
            for (Map.Entry entry : metaData.entrySet()) {
                jsonMetaData.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        jsonTask.add("metaData", (JsonElement)jsonMetaData);
        return jsonTask;
    }
}

