/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.jbpm.formapi.shared.form.FormEncodingException;
import org.jbpm.formapi.shared.form.FormEncodingFactory;
import org.jbpm.formapi.shared.menu.FormEffectDescription;
import org.jbpm.formapi.shared.menu.MenuItemDescription;
import org.jbpm.formbuilder.server.xml.FormEffectDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuItemDTO {
    private String _className;
    private String _optionName;
    private String _itemJson;
    private List<FormEffectDTO> _effect = new ArrayList();
    private List<String> _allowedEvent = new ArrayList();

    public MenuItemDTO() {
    }

    public MenuItemDTO(MenuItemDescription item) {
        this._className = item.getClassName();
        this._optionName = item.getName();
        for (FormEffectDescription eff : item.getEffects()) {
            this._effect.add(new FormEffectDTO(eff));
        }
        if (item.getAllowedEvents() != null) {
            this._allowedEvent.addAll(item.getAllowedEvents());
        }
        try {
            String json;
            this._itemJson = json = FormEncodingFactory.getEncoder().encode(item.getItemRepresentation());
        }
        catch (FormEncodingException formEncodingException) {
            // empty catch block
        }
    }

    @XmlElement
    public String getItemJson() {
        return this._itemJson;
    }

    public void setItemJson(String itemJson) {
        this._itemJson = itemJson;
    }

    @XmlAttribute
    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    @XmlElement
    public List<FormEffectDTO> getEffect() {
        return this._effect;
    }

    public void setEffect(List<FormEffectDTO> effect) {
        this._effect = effect;
    }

    @XmlElement
    public List<String> getAllowedEvent() {
        return this._allowedEvent;
    }

    public void setAllowedEvent(List<String> allowedEvent) {
        this._allowedEvent = allowedEvent;
    }

    @XmlAttribute
    public String getOptionName() {
        return this._optionName;
    }

    public void setOptionName(String optionName) {
        this._optionName = optionName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._allowedEvent == null ? 0 : ((Object)this._allowedEvent).hashCode());
        result = 31 * result + (this._className == null ? 0 : this._className.hashCode());
        result = 31 * result + (this._effect == null ? 0 : ((Object)this._effect).hashCode());
        result = 31 * result + (this._itemJson == null ? 0 : this._itemJson.hashCode());
        result = 31 * result + (this._optionName == null ? 0 : this._optionName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MenuItemDTO other = (MenuItemDTO)obj;
        if (this._allowedEvent == null ? other._allowedEvent != null : !((Object)this._allowedEvent).equals(other._allowedEvent)) {
            return false;
        }
        if (this._className == null ? other._className != null : !this._className.equals(other._className)) {
            return false;
        }
        if (this._effect == null ? other._effect != null : !((Object)this._effect).equals(other._effect)) {
            return false;
        }
        if (this._itemJson == null ? other._itemJson != null : !this._itemJson.equals(other._itemJson)) {
            return false;
        }
        return !(this._optionName == null ? other._optionName != null : !this._optionName.equals(other._optionName));
    }
}

