/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.I18NFormItem;
import org.jbpm.formapi.client.form.LayoutFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.common.panels.FieldSetPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.FieldSetPanelRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.form.I18NUtils;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class FieldSetLayoutFormItem
extends LayoutFormItem
implements I18NFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final I18NUtils utils = new I18NUtils();
    private String cssClassName;
    private String id;
    private String legend;
    private FieldSetPanel panel = new /* Unavailable Anonymous Inner Class!! */;

    public FieldSetLayoutFormItem() {
        this(new ArrayList());
    }

    public FieldSetLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.setSize("250px", "120px");
        this.panel.setSize(this.getWidth(), this.getHeight());
        this.add((Widget)this.panel);
    }

    public void replacePhantom(FBFormItem item) {
        PhantomPanel phantom = null;
        for (Widget widget : this.panel) {
            if (!(widget instanceof PhantomPanel)) continue;
            phantom = (PhantomPanel)widget;
            break;
        }
        if (phantom != null) {
            int index = this.panel.getWidgetIndex(phantom);
            super.insert(index, item);
            this.remove((Widget)phantom);
        } else {
            this.add(item);
        }
    }

    public boolean add(FBFormItem item) {
        this.panel.add((Widget)item);
        return super.add(item);
    }

    public void add(PhantomPanel phantom, int x, int y) {
        for (int index = 0; index < this.panel.getWidgetCount(); ++index) {
            Widget item = this.panel.getWidget(index);
            int left = item.getAbsoluteLeft();
            int right = left + item.getOffsetWidth();
            int top = item.getAbsoluteTop();
            int bottom = top + item.getOffsetHeight();
            if (x <= left || x >= right || y <= top || y >= bottom) continue;
            this.panel.insert((Widget)phantom, index);
            break;
        }
    }

    public HasWidgets getPanel() {
        return this.panel;
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        formItemPropertiesMap.put("legend", this.legend);
        formItemPropertiesMap.put("id", this.id);
        return formItemPropertiesMap;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.legend = this.extractString(asPropertiesMap.get("legend"));
        this.populate(this.panel);
    }

    private void populate(FieldSetPanel panel) {
        if (this.getHeight() != null) {
            panel.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            panel.setStyleName(this.cssClassName);
        }
        if (this.legend != null) {
            panel.setLegend(this.legend);
        }
        if (this.id != null) {
            panel.setId(this.id);
        }
        if (this.getWidth() != null) {
            panel.setWidth(this.getWidth());
        }
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof FieldSetPanelRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "FieldSetPanelRepresentation"));
        }
        super.populate(rep);
        FieldSetPanelRepresentation fsrep = (FieldSetPanelRepresentation)rep;
        this.cssClassName = fsrep.getCssClassName();
        this.id = fsrep.getId();
        this.legend = fsrep.getLegend();
        if (fsrep.getWidth() != null && !"".equals(fsrep.getWidth())) {
            this.setWidth(fsrep.getWidth());
        }
        if (fsrep.getHeight() != null && !"".equals(fsrep.getHeight())) {
            this.setHeight(fsrep.getHeight());
        }
        this.populate(this.panel);
        if (fsrep.getItems() != null) {
            for (FormItemRepresentation item : fsrep.getItems()) {
                this.add(LayoutFormItem.createItem((FormItemRepresentation)item));
            }
        }
    }

    public FormItemRepresentation getRepresentation() {
        FieldSetPanelRepresentation rep = (FieldSetPanelRepresentation)super.getRepresentation((FormItemRepresentation)new FieldSetPanelRepresentation());
        rep.setCssClassName(this.cssClassName);
        rep.setId(this.id);
        rep.setHeight(this.getHeight());
        rep.setWidth(this.getWidth());
        rep.setLegend(this.legend);
        ArrayList<FormItemRepresentation> items = new ArrayList<FormItemRepresentation>();
        for (FBFormItem item : this.getItems()) {
            items.add(item.getRepresentation());
        }
        rep.setI18n(this.getI18nMap());
        rep.setItems(items);
        return rep;
    }

    public FBFormItem cloneItem() {
        FieldSetLayoutFormItem clone = (FieldSetLayoutFormItem)super.cloneItem((FBFormItem)new FieldSetLayoutFormItem(this.getFormEffects()));
        clone.cssClassName = this.cssClassName;
        clone.id = this.id;
        clone.legend = this.legend;
        clone.populate(clone.panel);
        for (FBFormItem item : this.getItems()) {
            clone.add(item.cloneItem());
        }
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> formData) {
        FieldSetPanel fsp = new FieldSetPanel();
        this.populate(fsp);
        String value = (String)this.getInputValue(formData);
        if (value != null) {
            fsp.setLegend(value);
        } else {
            String i18nText;
            String locale = (String)formData.get("org.jbpm.formbuilder.server.render.Renderer.BASE_LOCALE");
            fsp.setLegend(this.legend);
            if (locale != null && (i18nText = this.getI18n(locale)) != null && !"".equals(i18nText)) {
                fsp.setLegend(i18nText);
            }
        }
        super.populateActions(fsp.getElement());
        for (FBFormItem item : this.getItems()) {
            fsp.add(item.cloneDisplay(formData));
        }
        return fsp;
    }

    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    public I18NFormItem.Format getFormat() {
        return this.utils.getFormat();
    }

    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    public void saveI18nMap(Map<String, String> i18nMap) {
        this.utils.saveI18nMap(i18nMap);
    }

    public void setFormat(I18NFormItem.Format format) {
        this.utils.setFormat(format);
    }
}

