/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.RadioButtonRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class RadioButtonFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private RadioButton button = new RadioButton("");
    private String name;
    private String id;
    private String value;
    private Boolean selected = Boolean.FALSE;

    public RadioButtonFormItem() {
        this(new ArrayList());
    }

    public RadioButtonFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.button);
        this.setHeight("15px");
        this.setWidth("15px");
        this.button.setSize(this.getWidth(), this.getHeight());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("id", this.id);
        map.put("value", this.value);
        map.put("selected", this.selected);
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.value = this.extractString(asPropertiesMap.get("value"));
        this.selected = this.extractBoolean(asPropertiesMap.get("selected"));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.populate(this.button);
    }

    private void populate(RadioButton button) {
        if (this.name != null) {
            button.setName(this.name);
        }
        if (this.value != null) {
            button.setFormValue(this.value);
        }
        if (this.selected != null) {
            button.setValue(this.selected);
        }
        if (this.getWidth() != null) {
            button.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            button.setHeight(this.getHeight());
        }
    }

    public FormItemRepresentation getRepresentation() {
        RadioButtonRepresentation rep = (RadioButtonRepresentation)super.getRepresentation((FormItemRepresentation)new RadioButtonRepresentation());
        rep.setId(this.id);
        rep.setName(this.name);
        rep.setSelected(this.selected);
        rep.setValue(this.value);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof RadioButtonRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "RadioButtonRepresentation"));
        }
        super.populate(rep);
        RadioButtonRepresentation rrep = (RadioButtonRepresentation)rep;
        this.id = rrep.getId();
        this.name = rrep.getName();
        this.selected = rrep.getSelected();
        this.value = rrep.getValue();
        this.populate(this.button);
    }

    public FBFormItem cloneItem() {
        RadioButtonFormItem clone = new RadioButtonFormItem(this.getFormEffects());
        clone.id = this.id;
        clone.name = this.name;
        clone.selected = this.selected;
        clone.value = this.value;
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.populate(clone.button);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        RadioButton rb = new RadioButton("");
        this.populate(rb);
        Object input = this.getInputValue(data);
        if (input != null) {
            rb.setValue(Boolean.valueOf(input.toString()));
        }
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            rb.setName(this.getOutput().getName());
        }
        super.populateActions(rb.getElement());
        return rb;
    }
}

