/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.PasswordFieldRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class PasswordFieldFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final PasswordTextBox textBox = new PasswordTextBox();
    private String defaultContent = null;
    private String name = null;
    private String id = null;
    private String title = null;
    private Integer maxlength = null;

    public PasswordFieldFormItem() {
        this(new ArrayList());
    }

    public PasswordFieldFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.textBox);
        this.setWidth("100px");
        this.setHeight("21px");
        this.textBox.setSize(this.getWidth(), this.getHeight());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputDefaultContent", this.defaultContent);
        map.put("name", this.name);
        map.put("id", this.id);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("maxlength", this.maxlength);
        map.put("title", this.title);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.defaultContent = this.extractString(asPropertiesMap.get("inputDefaultContent"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.maxlength = this.extractInt(asPropertiesMap.get("maxlength"));
        this.populate(this.textBox);
    }

    private void populate(PasswordTextBox textBox) {
        if (this.defaultContent != null) {
            textBox.setValue((Object)this.defaultContent);
        }
        if (this.name != null) {
            textBox.setName(this.name);
        }
        if (this.getHeight() != null) {
            textBox.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            textBox.setWidth(this.getWidth());
        }
        if (this.title != null) {
            textBox.setTitle(this.title);
        }
        if (this.maxlength != null) {
            textBox.setMaxLength(this.maxlength.intValue());
        }
    }

    public FormItemRepresentation getRepresentation() {
        PasswordFieldRepresentation rep = (PasswordFieldRepresentation)super.getRepresentation((FormItemRepresentation)new PasswordFieldRepresentation());
        rep.setDefaultValue(this.defaultContent);
        rep.setName(this.name);
        rep.setId(this.id);
        rep.setMaxLength(this.maxlength);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof PasswordFieldRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "PasswordFieldRepresentation"));
        }
        super.populate(rep);
        PasswordFieldRepresentation prep = (PasswordFieldRepresentation)rep;
        this.defaultContent = prep.getDefaultValue();
        this.name = prep.getName();
        this.id = prep.getId();
        this.maxlength = prep.getMaxLength();
        if (prep.getWidth() != null && !"".equals(prep.getWidth())) {
            this.setWidth(prep.getWidth());
        }
        if (prep.getHeight() != null && !"".equals(prep.getHeight())) {
            this.setHeight(prep.getHeight());
        }
        this.populate(this.textBox);
    }

    public FBFormItem cloneItem() {
        PasswordFieldFormItem clone = new PasswordFieldFormItem(this.getFormEffects());
        clone.defaultContent = this.defaultContent;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.maxlength = this.maxlength;
        clone.name = this.name;
        clone.title = this.title;
        clone.setWidth(this.getWidth());
        clone.populate(clone.textBox);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        PasswordTextBox pb = new PasswordTextBox();
        this.populate(pb);
        Object input = this.getInputValue(data);
        if (input != null) {
            pb.setValue((Object)input.toString());
        }
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            pb.setName(this.getOutput().getName());
        }
        super.populateActions(pb.getElement());
        return pb;
    }
}

