/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect.scriptviews;

import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.effect.scripthandlers.ToggleScriptHelper;
import org.jbpm.formbuilder.client.messages.I18NConstants;

public class ToggleScriptHelperView
extends FlexTable {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final TextBox idField = new TextBox();
    private final ListBox actionOnEvent = new ListBox();
    private final ListBox hidingStrategy = new ListBox();

    public ToggleScriptHelperView(ToggleScriptHelper helper) {
        this.populateActionOnEventList();
        this.populateHidingStrategyList();
        this.readDataFrom(helper);
        this.setWidget(0, 0, (Widget)new Label(this.i18n.ToggleScriptHelperIdField()));
        this.setWidget(0, 1, (Widget)this.idField);
        this.setWidget(1, 0, (Widget)new Label(this.i18n.ToggleScriptHelperActionOnEvent()));
        this.setWidget(1, 1, (Widget)this.actionOnEvent);
        this.setWidget(2, 0, (Widget)new Label(this.i18n.ToggleScriptHelperHidingStrategy()));
        this.setWidget(2, 1, (Widget)this.hidingStrategy);
    }

    private void populateActionOnEventList() {
        this.actionOnEvent.addItem(this.i18n.ToggleScriptHelperToggleAction(), "toggle");
        this.actionOnEvent.addItem(this.i18n.ToggleScriptHelperHideAction(), "hide");
        this.actionOnEvent.addItem(this.i18n.ToggleScriptHelperShowAction(), "show");
        this.actionOnEvent.setSelectedIndex(0);
    }

    private void populateHidingStrategyList() {
        this.hidingStrategy.addItem(this.i18n.ToggleScriptHelperHiddenStrategy(), "hidden");
        this.hidingStrategy.addItem(this.i18n.ToggleScriptHelperCollapseStrategy(), "collapse");
        this.hidingStrategy.setSelectedIndex(0);
    }

    public void writeDataTo(ToggleScriptHelper helper) {
        helper.setActionOnEvent(this.actionOnEvent.getValue(this.actionOnEvent.getSelectedIndex()));
        helper.setHidingStrategy(this.hidingStrategy.getValue(this.hidingStrategy.getSelectedIndex()));
        helper.setIdField(this.idField.getValue());
    }

    public void readDataFrom(ToggleScriptHelper helper) {
        int index;
        for (index = 0; index < this.hidingStrategy.getItemCount(); ++index) {
            if (!this.hidingStrategy.getValue(index).equals(helper.getHidingStrategy())) continue;
            this.hidingStrategy.setSelectedIndex(index);
            break;
        }
        for (index = 0; index < this.actionOnEvent.getItemCount(); ++index) {
            if (!this.actionOnEvent.getValue(index).equals(helper.getActionOnEvent())) continue;
            this.actionOnEvent.setSelectedIndex(index);
            break;
        }
        this.idField.setValue((Object)helper.getIdField());
    }
}

