/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.ScriptElement;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.HasSourceReference;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.ClientScriptRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.form.items.ClientScriptFormItem;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.resources.FormBuilderResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class ClientScriptFormItem
extends FBFormItem
implements HasSourceReference {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private ScriptElement script = Document.get().createScriptElement();
    private String type = "text/javascript";
    private String src = null;

    public ClientScriptFormItem() {
        this(new ArrayList());
    }

    public ClientScriptFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        Grid border = new Grid(1, 1);
        border.setSize("100px", "20px");
        border.setBorderWidth(1);
        border.getCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER);
        border.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        border.setWidget(0, 0, (Widget)new Image(FormBuilderResources.INSTANCE.clientScriptIcon()));
        border.getElement().insertFirst((Node)this.script);
        this.add((Widget)border);
        this.setSize("100px", "20px");
    }

    public void setSourceReference(String sourceReference) {
        this.script.setSrc(sourceReference);
    }

    public String getSourceReference() {
        return this.script.getSrc();
    }

    public List<String> getAllowedTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("js");
        return retval;
    }

    private void populate(ScriptElement script) {
        script.setSrc(this.src);
        script.setType(this.type);
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", this.type);
        map.put("src", this.src);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.type = this.extractString(asPropertiesMap.get("type"));
        this.src = this.extractString(asPropertiesMap.get("src"));
        this.populate(this.script);
    }

    public FormItemRepresentation getRepresentation() {
        ClientScriptRepresentation rep = (ClientScriptRepresentation)super.getRepresentation((FormItemRepresentation)new ClientScriptRepresentation());
        rep.setType(this.type);
        rep.setSrc(this.src);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof ClientScriptRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "ClientScriptRepresentation"));
        }
        super.populate(rep);
        ClientScriptRepresentation csrep = (ClientScriptRepresentation)rep;
        this.src = csrep.getSrc();
        this.type = csrep.getType();
        this.populate(this.script);
    }

    public FBFormItem cloneItem() {
        ClientScriptFormItem clone = (ClientScriptFormItem)super.cloneItem((FBFormItem)new ClientScriptFormItem());
        clone.src = this.src;
        clone.type = this.type;
        this.populate(clone.script);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        MyWidget widget = new MyWidget(this);
        widget.set(this.script);
        super.populateActions(widget.getElement());
        return widget;
    }
}

