/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.FBInplaceEditor;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.HTMLRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.form.editors.HTMLFormItemEditor;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class HTMLFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private HTML html = new HTML();

    public HTMLFormItem() {
        this(new ArrayList());
    }

    public HTMLFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.html.setHTML("<div style=\"background-color: #DDDDDD; \">HTML: Click to edit</div>");
        this.add((Widget)this.html);
        this.setWidth("200px");
        this.setHeight("100px");
        this.setSize(this.getWidth(), this.getHeight());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    public FBInplaceEditor createInplaceEditor() {
        return new HTMLFormItemEditor(this);
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.populate(this.html);
    }

    private void populate(HTML html) {
        if (this.getWidth() != null) {
            html.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            html.setHeight(this.getHeight());
        }
    }

    public void setContent(String html) {
        this.html.setHTML(html);
    }

    public FormItemRepresentation getRepresentation() {
        HTMLRepresentation rep = (HTMLRepresentation)super.getRepresentation((FormItemRepresentation)new HTMLRepresentation());
        rep.setContent(this.html.getHTML());
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof HTMLRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "HTMLRepresentation"));
        }
        super.populate(rep);
        HTMLRepresentation hrep = (HTMLRepresentation)rep;
        this.setContent(hrep.getContent());
    }

    public FBFormItem cloneItem() {
        HTMLFormItem clone = new HTMLFormItem(this.getFormEffects());
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.setContent(this.html.getHTML());
        clone.populate(clone.html);
        return clone;
    }

    public String getTextContent() {
        return this.html.getText();
    }

    public String getHtmlContent() {
        return this.html.getHTML();
    }

    public void setTextContent(String textContent) {
        this.html.setText(textContent);
    }

    public void setHtmlContent(String htmlContent) {
        this.html.setHTML(htmlContent);
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        HTML html = new HTML();
        html.setHTML(this.html.getHTML());
        this.populate(html);
        super.populateActions(html.getElement());
        return html;
    }
}

