/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.providers.jaxb.DoNotUseJAXBProvider;
import org.jbpm.formbuilder.server.RESTBaseService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Path(value="/user")
public class RESTUserService
extends RESTBaseService {
    private static final String[] AVAILABLE_ROLES = new String[]{"admin", "webdesigner", "functionalanalyst"};

    @GET
    @Path(value="/current/roles")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @DoNotUseJAXBProvider
    public Response getCurrentRoles(@Context HttpServletRequest request) {
        List roles = RESTUserService.getRoles((HttpServletRequest)request);
        StringBuilder txtRoles = new StringBuilder();
        Iterator iter = roles.iterator();
        while (iter.hasNext()) {
            txtRoles.append((String)iter.next());
            if (!iter.hasNext()) continue;
            txtRoles.append(",");
        }
        return Response.ok((Object)txtRoles.toString()).build();
    }

    @POST
    @Path(value="/current/logout")
    public Response logout(@Context HttpServletRequest request) {
        request.getSession().invalidate();
        return Response.ok().build();
    }

    public static List<String> getRoles(HttpServletRequest request) {
        ArrayList<String> roles = new ArrayList<String>();
        for (String role : AVAILABLE_ROLES) {
            if (!request.isUserInRole(role)) continue;
            roles.add(role);
        }
        return roles;
    }

    public static boolean hasDesignerPrivileges(HttpServletRequest request) {
        List roles = RESTUserService.getRoles((HttpServletRequest)request);
        return roles.contains("admin") || roles.contains("webdesigner");
    }
}

