/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.HashMap;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.OptionsFormItem;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.bus.UndoableEvent;
import org.jbpm.formbuilder.client.bus.UndoableHandler;
import org.jbpm.formbuilder.client.messages.I18NConstants;

@Reflectable
public class DeleteItemFormEffect
extends FBFormEffect {
    private String dropItemLabel;
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();

    public DeleteItemFormEffect() {
        super(FormBuilderGlobals.getInstance().getI18n().DeleteItemFormEffectLabel(), true);
    }

    public void setDropItemLabel(String dropItemLabel) {
        this.dropItemLabel = dropItemLabel;
    }

    public String getDropItemLabel() {
        return this.dropItemLabel;
    }

    protected void createStyles() {
        OptionsFormItem opt = (OptionsFormItem)super.getItem();
        opt.deleteItem(this.getDropItemLabel());
    }

    protected void revertStyles(String label, String value) {
        OptionsFormItem opt = (OptionsFormItem)super.getItem();
        opt.addItem(label, value);
    }

    protected String getValue(String label) {
        FBFormItem item = super.getItem();
        String value = null;
        if (item instanceof OptionsFormItem) {
            OptionsFormItem opt = (OptionsFormItem)item;
            value = (String)opt.getItems().get(label);
        }
        return value;
    }

    public PopupPanel createPanel() {
        PopupPanel panel = new PopupPanel();
        panel.setSize("150px", "66px");
        VerticalPanel vPanel = new VerticalPanel();
        HorizontalPanel hPanel1 = new HorizontalPanel();
        hPanel1.add((Widget)new Label(FormBuilderGlobals.getInstance().getI18n().LabelToDelete()));
        TextBox labelBox = new TextBox();
        labelBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        hPanel1.add((Widget)labelBox);
        Button applyButton = new Button(this.i18n.ConfirmButton());
        applyButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        vPanel.add((Widget)hPanel1);
        vPanel.add((Widget)applyButton);
        panel.add((Widget)vPanel);
        return panel;
    }

    private void undoableEffect(PopupPanel panel, String label) {
        HashMap<String, String> dataSnapshot = new HashMap<String, String>();
        dataSnapshot.put("deletedLabel", label);
        dataSnapshot.put("deletedValue", this.getValue(label));
        this.bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, (UndoableHandler)new /* Unavailable Anonymous Inner Class!! */));
    }

    public boolean isValidForItem(FBFormItem item) {
        return super.isValidForItem(item) && item instanceof OptionsFormItem;
    }

    static /* synthetic */ void access$000(DeleteItemFormEffect x0, PopupPanel x1, String x2) {
        x0.undoableEffect(x1, x2);
    }
}

