/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.FBInplaceEditor;
import org.jbpm.formapi.client.form.I18NFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.HeaderRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.form.I18NUtils;
import org.jbpm.formbuilder.client.form.editors.HeaderInplaceEditor;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class HeaderFormItem
extends FBFormItem
implements I18NFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final HTML header = new HTML("<h1>" + this.i18n.MenuItemHeader() + "</h1>");
    private final I18NUtils utils = new I18NUtils();
    private String id;
    private String name;
    private String cssClassName;

    public HeaderFormItem() {
        this(new ArrayList());
    }

    public HeaderFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.getHeader());
        this.setWidth("99%");
        this.setHeight("30px");
        this.getHeader().setSize(this.getWidth(), this.getHeight());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("id", this.id);
        formItemPropertiesMap.put("name", this.name);
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        return formItemPropertiesMap;
    }

    public FBInplaceEditor createInplaceEditor() {
        return new HeaderInplaceEditor(this);
    }

    public void saveValues(Map<String, Object> propertiesMap) {
        this.id = this.extractString(propertiesMap.get("id"));
        this.name = this.extractString(propertiesMap.get("name"));
        this.setWidth(this.extractString(propertiesMap.get("width")));
        this.setHeight(this.extractString(propertiesMap.get("height")));
        this.cssClassName = this.extractString(propertiesMap.get("cssClassName"));
        this.populate(this.getHeader());
    }

    private void populate(HTML html) {
        if (this.getWidth() != null) {
            html.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            html.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            html.setStyleName(this.cssClassName);
        }
    }

    public HTML getHeader() {
        return this.header;
    }

    public void setContent(String html) {
        this.getHeader().setHTML(html);
    }

    public void addEffect(FBFormEffect effect) {
        super.addEffect(effect);
        effect.setWidget((Widget)this.header);
    }

    public FormItemRepresentation getRepresentation() {
        HeaderRepresentation rep = (HeaderRepresentation)super.getRepresentation((FormItemRepresentation)new HeaderRepresentation());
        rep.setValue(this.header.getText());
        rep.setStyleClass(this.cssClassName);
        rep.setCssId(this.id);
        rep.setCssName(this.name);
        rep.setI18n(this.getI18nMap());
        rep.setFormat(this.getFormat() == null ? null : this.getFormat().toString());
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof HeaderRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "HeaderRepresentation"));
        }
        super.populate(rep);
        HeaderRepresentation hrep = (HeaderRepresentation)rep;
        this.cssClassName = hrep.getCssName();
        this.id = hrep.getCssId();
        this.saveI18nMap(hrep.getI18n());
        if (hrep.getValue().startsWith("<h1>")) {
            this.setContent(hrep.getValue());
        } else {
            this.setContent("<h1>" + hrep.getValue() + "</h1>");
        }
        if (hrep.getFormat() != null && !"".equals(hrep.getFormat())) {
            this.setFormat(I18NFormItem.Format.valueOf((String)hrep.getFormat()));
        }
    }

    public FBFormItem cloneItem() {
        HeaderFormItem clone = (HeaderFormItem)super.cloneItem((FBFormItem)new HeaderFormItem(this.getFormEffects()));
        clone.cssClassName = this.cssClassName;
        clone.id = this.id;
        clone.name = this.name;
        clone.setContent(this.header.getHTML());
        clone.saveI18nMap(this.getI18nMap());
        clone.setFormat(this.getFormat());
        clone.populate(this.header);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        HTML html = new HTML(this.header.getHTML());
        this.populate(html);
        String value = (String)this.getInputValue(data);
        if (value != null) {
            html.setHTML("<h1>" + value + "</h1>");
        } else {
            String i18nText;
            String locale = (String)data.get("org.jbpm.formbuilder.server.render.Renderer.BASE_LOCALE");
            html.setHTML(this.header.getHTML());
            if (locale != null && (i18nText = this.getI18n(locale)) != null && !"".equals(i18nText)) {
                html.setHTML("<h1>" + i18nText + "</h1>");
            }
        }
        super.populateActions(html.getElement());
        return html;
    }

    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    public void saveI18nMap(Map<String, String> i18nMap) {
        if (i18nMap != null) {
            String defaultI18n = i18nMap.get("default");
            if (defaultI18n != null && !"".equals(defaultI18n)) {
                this.header.setHTML("<h1>" + defaultI18n + "</h1>");
            }
            this.utils.saveI18nMap(i18nMap);
        }
    }

    public I18NFormItem.Format getFormat() {
        return this.utils.getFormat();
    }

    public void setFormat(I18NFormItem.Format format) {
        this.utils.setFormat(format);
    }
}

