/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.bus.ui.NotificationEvent;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.LayoutFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.InputData;
import org.jbpm.formapi.shared.api.items.LoopBlockRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class LoopBlockFormItem
extends LayoutFormItem {
    private String variableName;
    private SimplePanel loopBlock = new SimplePanel();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();

    public LoopBlockFormItem() {
        this(new ArrayList());
    }

    public LoopBlockFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.loopBlock.setStyleName("loopBlockBorder");
        this.loopBlock.setSize("100%", "50px");
        this.add((Widget)this.loopBlock);
        this.setSize("100%", "50px");
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("variableName", this.variableName);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.variableName = this.extractString(asPropertiesMap.get("variableName"));
    }

    public FormItemRepresentation getRepresentation() {
        LoopBlockRepresentation rep = (LoopBlockRepresentation)this.getRepresentation((FormItemRepresentation)new LoopBlockRepresentation());
        rep.setInputName(this.getInput() == null ? null : this.getInput().getName());
        FBFormItem loopItem = (FBFormItem)this.loopBlock.getWidget();
        if (loopItem != null) {
            rep.setLoopBlock(loopItem.getRepresentation());
        }
        rep.setVariableName(this.variableName);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof LoopBlockRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "LoopBlockRepresentation"));
        }
        super.populate(rep);
        LoopBlockRepresentation lrep = (LoopBlockRepresentation)rep;
        this.variableName = lrep.getVariableName();
        this.loopBlock.clear();
        if (lrep.getInputName() != null && !"".equals(lrep.getInputName())) {
            InputData input = new InputData();
            input.setName(lrep.getInputName());
            lrep.setInput(input);
        }
        if (lrep.getLoopBlock() != null) {
            FBFormItem child = LayoutFormItem.createItem((FormItemRepresentation)lrep.getLoopBlock());
            this.loopBlock.add((Widget)child);
        }
    }

    public FBFormItem cloneItem() {
        LoopBlockFormItem clone = (LoopBlockFormItem)super.cloneItem((FBFormItem)new LoopBlockFormItem(this.getFormEffects()));
        FBFormItem loopItem = (FBFormItem)this.loopBlock.getWidget();
        clone.add(loopItem);
        clone.variableName = this.variableName;
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        String inputName;
        FlowPanel display = new FlowPanel();
        FBFormItem subItem = (FBFormItem)this.loopBlock.getWidget();
        Object input = this.getInputValue(data);
        String string = inputName = this.getInput() == null ? null : this.getInput().getName();
        if (subItem != null && input != null && inputName != null) {
            HashMap<String, Object> subData = new HashMap<String, Object>();
            if (input.getClass().isArray()) {
                Object[] arr;
                for (Object obj : arr = (Object[])input) {
                    subData.put(inputName, obj);
                    display.add(subItem.cloneDisplay(subData));
                }
            } else if (input instanceof Collection) {
                Collection col = (Collection)input;
                for (Object obj : col) {
                    subData.put(inputName, obj);
                    display.add(subItem.cloneDisplay(subData));
                }
            } else if (input instanceof Map) {
                Map map = (Map)input;
                for (Map.Entry obj : map.entrySet()) {
                    subData.put(inputName, obj);
                    display.add(subItem.cloneDisplay(subData));
                }
            }
        }
        display.setSize(this.getWidth(), this.getHeight());
        super.populateActions(display.getElement());
        return display;
    }

    public HasWidgets getPanel() {
        return this.loopBlock;
    }

    public boolean add(FBFormItem item) {
        if (this.loopBlock.getWidget() == null) {
            this.loopBlock.setWidget((Widget)item);
            return super.add(item);
        }
        this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.LoopBlockFull()));
        return false;
    }

    public void add(PhantomPanel phantom, int x, int y) {
        if (this.loopBlock.getWidget() == null) {
            this.loopBlock.setWidget((Widget)phantom);
        }
    }

    public void replacePhantom(FBFormItem item) {
        if (this.loopBlock.getWidget() == null || this.loopBlock.getWidget() instanceof PhantomPanel) {
            this.loopBlock.remove(this.loopBlock.getWidget());
            this.loopBlock.setWidget((Widget)item);
        }
    }
}

