/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.menu;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

public class FormDataPopupPanel
extends PopupPanel {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final ListBox enctype = new ListBox(false);
    private final ListBox method = new ListBox(false);
    private final TextBox action = new TextBox();
    private final TextBox taskId = new TextBox();
    private final TextBox processId = new TextBox();
    private final TextBox name = new TextBox();
    private final TextArea documentation = new TextArea();

    public FormDataPopupPanel() {
        this(false);
    }

    public FormDataPopupPanel(boolean showForSavingForm) {
        super(true);
        this.setStyleName("commandPopupPanel");
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        Grid grid = new Grid(7, 2);
        this.enctype.addItem("multipart/form-data");
        this.enctype.addItem("application/x-www-form-urlencoded");
        this.enctype.setSelectedIndex(0);
        this.action.setValue((Object)"complete");
        this.method.addItem("POST");
        this.method.addItem("GET");
        this.method.setSelectedIndex(0);
        if (showForSavingForm) {
            this.method.setEnabled(false);
            this.enctype.setEnabled(false);
            this.action.setEnabled(false);
            this.taskId.setEnabled(false);
            this.processId.setEnabled(false);
            this.documentation.setCharacterWidth(30);
            this.documentation.setVisibleLines(4);
            grid.setWidget(0, 0, (Widget)new Label(this.i18n.CheckInComment()));
            grid.setWidget(0, 1, (Widget)this.documentation);
        } else {
            grid.setWidget(0, 0, (Widget)new HTML("&nbsp;"));
            grid.setWidget(0, 1, (Widget)new HTML("&nbsp;"));
        }
        grid.setWidget(1, 0, (Widget)new Label(this.i18n.FormAction()));
        grid.setWidget(1, 1, (Widget)this.action);
        grid.setWidget(2, 0, (Widget)new Label(this.i18n.FormMethod()));
        grid.setWidget(2, 1, (Widget)this.method);
        grid.setWidget(3, 0, (Widget)new Label(this.i18n.FormEnctype()));
        grid.setWidget(3, 1, (Widget)this.enctype);
        grid.setWidget(4, 0, (Widget)new Label(this.i18n.FormProcessId()));
        grid.setWidget(4, 1, (Widget)this.processId);
        grid.setWidget(5, 0, (Widget)new Label(this.i18n.FormTaskId()));
        grid.setWidget(5, 1, (Widget)this.taskId);
        grid.setWidget(6, 0, (Widget)new Label(this.i18n.FormName()));
        grid.setWidget(6, 1, (Widget)this.name);
        vPanel.add((Widget)grid);
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.add((Widget)new Button(this.i18n.ConfirmButton(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        buttonPanel.add((Widget)new Button(this.i18n.CancelButton(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        vPanel.add((Widget)buttonPanel);
        vPanel.setStyleName("commandContent");
        this.setWidget((Widget)vPanel);
    }

    public void setTaskId(String taskId) {
        this.taskId.setValue((Object)taskId);
    }

    public void setProcessId(String processId) {
        this.processId.setValue((Object)processId);
    }

    public void setEnctype(String enctype) {
        for (int index = 0; index < this.enctype.getItemCount(); ++index) {
            if (!this.enctype.getValue(index).equals(enctype)) continue;
            this.enctype.setSelectedIndex(index);
            break;
        }
    }

    public void setMethod(String method) {
        for (int index = 0; index < this.method.getItemCount(); ++index) {
            if (!this.method.getValue(index).equals(method)) continue;
            this.method.setSelectedIndex(index);
            break;
        }
    }

    public void setAction(String action) {
        this.action.setValue((Object)action);
    }

    public void setName(String name) {
        this.name.setValue((Object)name);
    }

    public String getFormName() {
        return this.name.getValue();
    }

    public String getAction() {
        return this.action.getValue();
    }

    public String getTaskId() {
        return this.taskId.getValue();
    }

    public String getProcessId() {
        return this.processId.getValue();
    }

    public String getMethod() {
        return this.method.getValue(this.method.getSelectedIndex());
    }

    public String getEnctype() {
        return this.enctype.getValue(this.enctype.getSelectedIndex());
    }

    public String getDocumentation() {
        return this.documentation.getValue();
    }

    protected void onLoad() {
        super.onLoad();
        int left = this.getPopupLeft();
        int top = this.getPopupTop();
        int width = this.getOffsetWidth();
        int height = this.getOffsetHeight();
        boolean changed = false;
        if (left + width > Window.getClientWidth()) {
            left -= width;
            changed = true;
        }
        if (top + height > Window.getClientHeight()) {
            top -= height;
            changed = true;
        }
        if (changed) {
            this.setPopupPosition(left, top);
        }
    }

    static /* synthetic */ TextBox access$000(FormDataPopupPanel x0) {
        return x0.action;
    }

    static /* synthetic */ ListBox access$100(FormDataPopupPanel x0) {
        return x0.method;
    }

    static /* synthetic */ TextBox access$200(FormDataPopupPanel x0) {
        return x0.taskId;
    }

    static /* synthetic */ TextBox access$300(FormDataPopupPanel x0) {
        return x0.processId;
    }

    static /* synthetic */ ListBox access$400(FormDataPopupPanel x0) {
        return x0.enctype;
    }

    static /* synthetic */ TextBox access$500(FormDataPopupPanel x0) {
        return x0.name;
    }

    static /* synthetic */ EventBus access$600(FormDataPopupPanel x0) {
        return x0.bus;
    }
}

