/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.options;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import java.util.LinkedList;
import java.util.List;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formbuilder.client.bus.UndoRedoEvent;
import org.jbpm.formbuilder.client.bus.UndoableEvent;

public class UndoRedoManager {
    private static final UndoRedoManager INSTANCE = new UndoRedoManager();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private List<UndoableEvent> undoRedoWindow = new LinkedList();
    private int index = -1;

    public static UndoRedoManager getInstance() {
        return INSTANCE;
    }

    private UndoRedoManager() {
        this.bus.addHandler(UndoableEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected synchronized void syncAdd(UndoableEvent event) {
        ++this.index;
        while (this.index < this.undoRedoWindow.size()) {
            this.undoRedoWindow.remove(this.index);
        }
        this.undoRedoWindow.add(event);
    }

    public synchronized void undo() {
        if (this.canUndo()) {
            UndoableEvent event = (UndoableEvent)this.undoRedoWindow.get(this.index);
            --this.index;
            event.getRollbackHandler().undoAction(event);
            this.bus.fireEvent((GwtEvent)new UndoRedoEvent());
        }
    }

    public synchronized void redo() {
        if (this.canRedo()) {
            ++this.index;
            UndoableEvent event = (UndoableEvent)this.undoRedoWindow.get(this.index);
            event.getRollbackHandler().doAction(event);
            this.bus.fireEvent((GwtEvent)new UndoRedoEvent());
        }
    }

    public boolean canUndo() {
        return this.undoRedoWindow.size() > 0 && this.index >= 0;
    }

    public boolean canRedo() {
        return this.undoRedoWindow.size() > 0 && this.index < this.undoRedoWindow.size() - 1;
    }
}

