/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.menu;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.VFS;
import org.jbpm.formapi.shared.form.FormEncodingException;
import org.jbpm.formapi.shared.form.FormEncodingFactory;
import org.jbpm.formapi.shared.form.FormRepresentationDecoder;
import org.jbpm.formapi.shared.form.FormRepresentationEncoder;
import org.jbpm.formapi.shared.menu.MenuItemDescription;
import org.jbpm.formapi.shared.menu.MenuOptionDescription;
import org.jbpm.formapi.shared.menu.ValidationDescription;
import org.jbpm.formbuilder.shared.menu.AbstractBaseMenuService;
import org.jbpm.formbuilder.shared.menu.MenuServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuvnorMenuService
extends AbstractBaseMenuService {
    public List<MenuOptionDescription> listOptions() throws MenuServiceException {
        Gson gson = new Gson();
        List retval = null;
        try {
            URL url = this.asURL("/menuOptions.json");
            retval = (List)gson.fromJson(this.createReader(url), new /* Unavailable Anonymous Inner Class!! */.getType());
        }
        catch (URISyntaxException e) {
            throw new MenuServiceException("Problem finding menu options json file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new MenuServiceException("No menu options json file found", (Throwable)e);
        }
        catch (Exception e) {
            throw new MenuServiceException("Unexpected error", (Throwable)e);
        }
        return retval;
    }

    public Map<String, List<MenuItemDescription>> listMenuItems() throws MenuServiceException {
        Map retval = null;
        try {
            FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
            URL url = this.asURL("/menuItems.json");
            String json = this.readURL(url);
            retval = decoder.decodeMenuItemsMap(json);
        }
        catch (FormEncodingException e) {
            throw new MenuServiceException("Problem parsing menu items json file", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new MenuServiceException("Problem finding menu items json file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new MenuServiceException("No menu items json file found", (Throwable)e);
        }
        catch (IOException e) {
            throw new MenuServiceException("Problem reading menu items json file", (Throwable)e);
        }
        catch (Exception e) {
            throw new MenuServiceException("Unexpected error", (Throwable)e);
        }
        return retval;
    }

    public List<ValidationDescription> listValidations() throws MenuServiceException {
        Gson gson = new Gson();
        List retval = null;
        try {
            URL url = this.asURL("/validations.json");
            retval = (List)gson.fromJson(this.createReader(url), new /* Unavailable Anonymous Inner Class!! */.getType());
        }
        catch (URISyntaxException e) {
            throw new MenuServiceException("Problem finding validations json file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new MenuServiceException("No validations json file found", (Throwable)e);
        }
        catch (Exception e) {
            throw new MenuServiceException("Unexpected error", (Throwable)e);
        }
        return retval;
    }

    public void saveMenuItem(String groupName, MenuItemDescription item) throws MenuServiceException {
        Map items = this.listMenuItems();
        this.addToMap(groupName, item, items);
        this.writeMenuItems(items);
    }

    public void deleteMenuItem(String groupName, MenuItemDescription item) throws MenuServiceException {
        Map items = this.listMenuItems();
        this.removeFromMap(groupName, item, items);
        this.writeMenuItems(items);
    }

    public Map<String, String> getFormBuilderProperties() throws MenuServiceException {
        InputStream input = this.getClass().getResourceAsStream("/FormBuilder.properties");
        Properties props = new Properties();
        try {
            props.load(input);
        }
        catch (IOException e) {
            throw new MenuServiceException("Couldn't read FormBuilder.properties", (Throwable)e);
        }
        HashMap<String, String> retval = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            retval.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return retval;
    }

    private void writeMenuItems(Map<String, List<MenuItemDescription>> items) throws MenuServiceException {
        try {
            FormRepresentationEncoder encoder = FormEncodingFactory.getEncoder();
            String json = encoder.encodeMenuItemsMap(items);
            URL url = this.asURL("/menuItems.json");
            this.writeToURL(url, json);
        }
        catch (FormEncodingException e) {
            throw new MenuServiceException("Problem transforming menu items to json", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new MenuServiceException("Problem finding menu items json file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new MenuServiceException("No menu items json file found", (Throwable)e);
        }
        catch (IOException e) {
            throw new MenuServiceException("Problem writing menu items json file", (Throwable)e);
        }
        catch (Exception e) {
            throw new MenuServiceException("Unexpected error", (Throwable)e);
        }
    }

    protected void writeToURL(URL url, String json) throws FileNotFoundException, IOException {
        if (url.toExternalForm().startsWith("vfs")) {
            FileObject to = VFS.getManager().resolveFile(url.toExternalForm());
            File tmpFile = File.createTempFile("xxFilexx", ".json");
            FileUtils.writeStringToFile((File)tmpFile, (String)json);
            FileObject from = VFS.getManager().toFileObject(tmpFile);
            to.copyFrom(from, (FileSelector)new AllFileSelector());
            FileUtils.deleteQuietly((File)tmpFile);
        } else {
            FileUtils.writeStringToFile((File)FileUtils.toFile((URL)url), (String)json);
        }
    }

    protected URL asURL(String path) throws URISyntaxException {
        return this.getClass().getResource(path);
    }

    protected Reader createReader(URL url) throws FileNotFoundException, IOException {
        return new InputStreamReader(url.openStream());
    }

    protected String readURL(URL url) throws FileNotFoundException, IOException {
        if (url.toExternalForm().startsWith("vfs")) {
            FileObject from = VFS.getManager().resolveFile(url.toExternalForm());
            return IOUtils.toString((InputStream)from.getContent().getInputStream());
        }
        return FileUtils.readFileToString((File)FileUtils.toFile((URL)url));
    }
}

