/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.jbpm.formbuilder.server.xml.MetaData2DTO;
import org.jbpm.formbuilder.server.xml.PropertyDTO;
import org.jbpm.formbuilder.shared.task.TaskPropertyRef;
import org.jbpm.formbuilder.shared.task.TaskRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRefDTO {
    private String _processId;
    private String _taskName;
    private String _taskId;
    private List<PropertyDTO> _input = new ArrayList();
    private List<PropertyDTO> _output = new ArrayList();
    private List<MetaData2DTO> _metaData = new ArrayList();

    public TaskRefDTO() {
    }

    public TaskRefDTO(TaskRef task) {
        this._processId = task.getProcessId();
        this._taskName = task.getTaskName();
        this._taskId = task.getTaskId();
        List allInputs = task.getInputs();
        ArrayList<TaskPropertyRef> uniqueInputs = new ArrayList<TaskPropertyRef>();
        ArrayList<String> inputNames = new ArrayList<String>();
        for (TaskPropertyRef ref : allInputs) {
            if (inputNames.contains(ref.getName())) continue;
            inputNames.add(ref.getName());
            uniqueInputs.add(ref);
        }
        for (TaskPropertyRef ref : uniqueInputs) {
            this._input.add(new PropertyDTO(ref));
        }
        List allOutputs = task.getOutputs();
        ArrayList<TaskPropertyRef> uniqueOutputs = new ArrayList<TaskPropertyRef>();
        ArrayList<String> outputNames = new ArrayList<String>();
        for (TaskPropertyRef taskPropertyRef : allOutputs) {
            if (outputNames.contains(taskPropertyRef.getName())) continue;
            outputNames.add(taskPropertyRef.getName());
            uniqueOutputs.add(taskPropertyRef);
        }
        for (TaskPropertyRef taskPropertyRef : uniqueOutputs) {
            this._output.add(new PropertyDTO(taskPropertyRef));
        }
        for (Map.Entry entry : task.getMetaData().entrySet()) {
            this._metaData.add(new MetaData2DTO(entry));
        }
    }

    @XmlAttribute
    public String getProcessId() {
        return this._processId;
    }

    public void setProcessId(String processId) {
        this._processId = processId;
    }

    @XmlAttribute
    public String getTaskName() {
        return this._taskName;
    }

    public void setTaskName(String taskName) {
        this._taskName = taskName;
    }

    @XmlAttribute
    public String getTaskId() {
        return this._taskId;
    }

    public void setTaskId(String taskId) {
        this._taskId = taskId;
    }

    @XmlElement
    public List<PropertyDTO> getInput() {
        return this._input;
    }

    public void setInput(List<PropertyDTO> input) {
        this._input = input;
    }

    @XmlElement
    public List<PropertyDTO> getOutput() {
        return this._output;
    }

    public void setOutput(List<PropertyDTO> output) {
        this._output = output;
    }

    @XmlElement
    public List<MetaData2DTO> getMetaData() {
        return this._metaData;
    }

    public void setMetaData(List<MetaData2DTO> metaData) {
        this._metaData = metaData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._input == null ? 0 : ((Object)this._input).hashCode());
        result = 31 * result + (this._metaData == null ? 0 : ((Object)this._metaData).hashCode());
        result = 31 * result + (this._output == null ? 0 : ((Object)this._output).hashCode());
        result = 31 * result + (this._processId == null ? 0 : this._processId.hashCode());
        result = 31 * result + (this._taskId == null ? 0 : this._taskId.hashCode());
        result = 31 * result + (this._taskName == null ? 0 : this._taskName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskRefDTO other = (TaskRefDTO)obj;
        if (this._input == null ? other._input != null : !((Object)this._input).equals(other._input)) {
            return false;
        }
        if (this._metaData == null ? other._metaData != null : !((Object)this._metaData).equals(other._metaData)) {
            return false;
        }
        if (this._output == null ? other._output != null : !((Object)this._output).equals(other._output)) {
            return false;
        }
        if (this._processId == null ? other._processId != null : !this._processId.equals(other._processId)) {
            return false;
        }
        if (this._taskId == null ? other._taskId != null : !this._taskId.equals(other._taskId)) {
            return false;
        }
        return !(this._taskName == null ? other._taskName != null : !this._taskName.equals(other._taskName));
    }
}

