/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.shared.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formbuilder.shared.task.TaskPropertyRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRef {
    private String packageName;
    private String processId;
    private String processName;
    private String taskId;
    private List<TaskPropertyRef> inputs = new ArrayList();
    private List<TaskPropertyRef> outputs = new ArrayList();
    private Map<String, String> metaData = new HashMap();

    public List<TaskPropertyRef> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<TaskPropertyRef> inputs) {
        this.inputs = inputs;
    }

    public List<TaskPropertyRef> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<TaskPropertyRef> outputs) {
        this.outputs = outputs;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public boolean addInput(String key, String value) {
        if (this.getInput(key) != null) {
            return false;
        }
        TaskPropertyRef tpRef = new TaskPropertyRef();
        tpRef.setName(key);
        tpRef.setSourceExpresion(value);
        return this.inputs.add(tpRef);
    }

    public TaskPropertyRef getInput(String key) {
        for (TaskPropertyRef ref : this.inputs) {
            if (key == null || !key.equals(ref.getName())) continue;
            return ref;
        }
        return null;
    }

    public Object removeInput(String key) {
        return this.inputs.remove(this.getInput(key));
    }

    public boolean addOutput(String key, String value) {
        if (this.getOutput(key) != null) {
            return false;
        }
        TaskPropertyRef tpRef = new TaskPropertyRef();
        tpRef.setName(key);
        tpRef.setSourceExpresion(value);
        return this.outputs.add(tpRef);
    }

    public TaskPropertyRef getOutput(String key) {
        for (TaskPropertyRef ref : this.outputs) {
            if (key == null || !key.equals(ref.getName())) continue;
            return ref;
        }
        return null;
    }

    public Object removeOutput(String key) {
        return this.outputs.remove(this.getOutput(key));
    }

    public String getTaskName() {
        return this.taskId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setMetaData(Map<String, String> metaData) {
        this.metaData = metaData;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessName() {
        return this.processName;
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskRef)) {
            return false;
        }
        TaskRef other = (TaskRef)obj;
        boolean bl = equals = this.packageName == null && other.packageName == null || this.packageName != null && this.packageName.equals(other.packageName);
        if (!equals) {
            return equals;
        }
        boolean bl2 = equals = this.processId == null && other.processId == null || this.processId != null && this.processId.equals(other.processId);
        if (!equals) {
            return equals;
        }
        boolean bl3 = equals = this.processName == null && other.processName == null || this.processName != null && this.processName.equals(other.processName);
        if (!equals) {
            return equals;
        }
        boolean bl4 = equals = this.taskId == null && other.taskId == null || this.taskId != null && this.taskId.equals(other.taskId);
        if (!equals) {
            return equals;
        }
        boolean bl5 = equals = this.inputs == null && other.inputs == null || this.inputs != null && ((Object)this.inputs).equals(other.inputs);
        if (!equals) {
            return equals;
        }
        boolean bl6 = equals = this.outputs == null && other.outputs == null || this.outputs != null && ((Object)this.outputs).equals(other.outputs);
        if (!equals) {
            return equals;
        }
        equals = this.metaData == null && other.metaData == null || this.metaData != null && ((Object)this.metaData.entrySet()).equals(other.metaData.entrySet());
        return equals;
    }

    public int hashCode() {
        int result = super.hashCode();
        int aux = this.packageName == null ? 0 : this.packageName.hashCode();
        result = 37 * result + aux;
        aux = this.processId == null ? 0 : this.processId.hashCode();
        result = 37 * result + aux;
        aux = this.processName == null ? 0 : this.processName.hashCode();
        result = 37 * result + aux;
        aux = this.taskId == null ? 0 : this.taskId.hashCode();
        result = 37 * result + aux;
        aux = this.inputs == null ? 0 : ((Object)this.inputs).hashCode();
        result = 37 * result + aux;
        aux = this.outputs == null ? 0 : ((Object)this.outputs).hashCode();
        result = 37 * result + aux;
        aux = this.metaData == null ? 0 : ((Object)this.metaData).hashCode();
        result = 37 * result + aux;
        return result;
    }

    public String toString() {
        return "TaskRef[package=" + this.packageName + ";processId=" + this.processId + ";processName=" + this.processName + ";taskId=" + this.taskId + ";inputs=" + this.inputs + ";outputs=" + this.outputs + ";metaData=" + this.metaData + "]";
    }
}

