/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.command;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.formapi.shared.api.InputData;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputMapPanel
extends PopupPanel {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final Button okButton = new Button(this.i18n.OkButton());
    private final Button cancelButton = new Button(this.i18n.CancelButton());
    private final Map<String, InputData> inputs;
    private final Map<String, Object> retData = new HashMap();

    public InputMapPanel(Map<String, InputData> inputs) {
        super(false, true);
        this.inputs = inputs;
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        mainPanel.add((Widget)new Label(this.i18n.InputMapPopulation()));
        mainPanel.add((Widget)this.createInputTable());
        mainPanel.add((Widget)this.createButtonPanel());
        this.setWidget((Widget)mainPanel);
    }

    private Grid createInputTable() {
        Grid inputTable = new Grid(this.inputs.size(), 2);
        ArrayList inputList = new ArrayList(this.inputs.values());
        for (int index = 0; index < inputList.size(); ++index) {
            InputData input = (InputData)inputList.get(index);
            this.populateRetData(input);
            inputTable.setWidget(index, 0, (Widget)new Label(input.getName()));
            TextBox inputText = new TextBox();
            inputText.setValue((Object)input.getValue());
            inputText.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            inputTable.setWidget(index, 1, (Widget)inputText);
        }
        return inputTable;
    }

    private void populateRetData(InputData input) {
        if (input.getFormatter() == null) {
            this.retData.put(input.getName(), input.getValue());
        } else {
            this.retData.put(input.getName(), input.getFormatter().format((Object)input.getValue()));
        }
    }

    private HorizontalPanel createButtonPanel() {
        HorizontalPanel buttons = new HorizontalPanel();
        this.okButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        buttons.add((Widget)this.okButton);
        buttons.add((Widget)this.cancelButton);
        return buttons;
    }

    public HandlerRegistration addOkHandler(ClickHandler handler) {
        return this.okButton.addClickHandler(handler);
    }

    public Map<String, Object> getInputs() {
        return this.retData;
    }

    static /* synthetic */ void access$000(InputMapPanel x0, InputData x1) {
        x0.populateRetData(x1);
    }
}

