/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect.scriptviews;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.effect.scripthandlers.HeaderViewPanel;
import org.jbpm.formbuilder.client.effect.scripthandlers.RestServiceScriptHelper;
import org.jbpm.formbuilder.client.messages.I18NConstants;

public class RestServiceScriptHelperView
extends FlexTable {
    private final TextBox url = new TextBox();
    private final ListBox method = new ListBox();
    private final ListBox resultStatus = new ListBox();
    private final TextBox resultXPath = new TextBox();
    private final TextBox exportVariableName = new TextBox();
    private final ListBox responseLanguage = new ListBox();
    private final HeaderViewPanel headerViewPanel = new HeaderViewPanel();
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();

    public RestServiceScriptHelperView(RestServiceScriptHelper helper) {
        this.populateMethodList();
        this.populateResultStatusList();
        this.populateResponseLanguageList();
        this.readDataFrom(helper);
        this.setWidget(0, 0, (Widget)new Label(this.i18n.RestServiceScriptHelperUrl()));
        this.setWidget(0, 1, (Widget)this.url);
        this.setWidget(1, 0, (Widget)new Label(this.i18n.RestServiceScriptHelperMethod()));
        this.setWidget(1, 1, (Widget)this.method);
        this.setWidget(2, 0, (Widget)new Label(this.i18n.RestServiceScriptHelperResultStatus()));
        this.setWidget(2, 1, (Widget)this.resultStatus);
        this.setWidget(3, 0, (Widget)new Label(this.i18n.RestServiceScriptHelperResultPath()));
        this.setWidget(3, 1, (Widget)this.resultXPath);
        this.setWidget(4, 0, (Widget)new Label(this.i18n.RestServiceScriptHelperExportVariable()));
        this.setWidget(4, 1, (Widget)this.exportVariableName);
        this.setWidget(5, 0, (Widget)new Label(this.i18n.RestServiceScriptHelperResponseLanguage()));
        this.setWidget(5, 1, (Widget)this.responseLanguage);
        this.setWidget(6, 0, (Widget)new Label(this.i18n.RestServiceScriptHelperSendHeaders()));
        this.setWidget(6, 1, (Widget)new Button(this.i18n.RestServiceScriptHelperAddHeader(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        this.setWidget(7, 0, (Widget)this.headerViewPanel);
        this.getFlexCellFormatter().setColSpan(7, 0, 2);
    }

    private void populateResponseLanguageList() {
        this.responseLanguage.addItem("xml");
        this.responseLanguage.addItem("json");
    }

    private void populateResultStatusList() {
        this.resultStatus.addItem("200 - OK", "200");
        this.resultStatus.addItem("201 - Created", "201");
        this.resultStatus.addItem("404 - Not found", "404");
        this.resultStatus.addItem("500 - Server error", "500");
    }

    private void populateMethodList() {
        this.method.addItem("GET");
        this.method.addItem("POST");
        this.method.addItem("PUT");
        this.method.addItem("DELETE");
    }

    public void readDataFrom(RestServiceScriptHelper helper) {
        int index;
        this.url.setValue((Object)helper.getUrl());
        for (index = 0; index < this.method.getItemCount(); ++index) {
            if (!this.method.getValue(index).equals(helper.getMethod())) continue;
            this.method.setSelectedIndex(index);
            break;
        }
        for (index = 0; index < this.resultStatus.getItemCount(); ++index) {
            if (!this.resultStatus.getValue(index).equals(helper.getResultStatus())) continue;
            this.resultStatus.setSelectedIndex(index);
            break;
        }
        this.resultXPath.setValue((Object)helper.getResultXPath());
        this.exportVariableName.setValue((Object)helper.getExportVariableName());
        for (index = 0; index < this.responseLanguage.getItemCount(); ++index) {
            if (!this.responseLanguage.getValue(index).equals(helper.getResponseLanguage())) continue;
            this.responseLanguage.setSelectedIndex(index);
            break;
        }
        this.headerViewPanel.clear();
        if (helper.getHeaders() != null) {
            for (Map.Entry entry : helper.getHeaders().entrySet()) {
                this.headerViewPanel.addHeaderRow((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void writeDataTo(RestServiceScriptHelper helper) {
    }

    static /* synthetic */ HeaderViewPanel access$000(RestServiceScriptHelperView x0) {
        return x0.headerViewPanel;
    }
}

