/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.tasks;

import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.common.handler.EventHelper;
import org.jbpm.formapi.common.handler.RightClickHandler;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.shared.task.TaskPropertyRef;
import org.jbpm.formbuilder.shared.task.TaskRef;

public class TaskRow
extends FocusPanel {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final List<HandlerRegistration> rclickRegs = new ArrayList();
    private final TaskRef ioRef;
    private final VerticalPanel panel = new VerticalPanel();
    private final HandlerRegistration focus;
    private final HandlerRegistration blur;
    private final VerticalPanel inputs = new VerticalPanel();
    private final VerticalPanel outputs = new VerticalPanel();
    private final VerticalPanel metaData = new VerticalPanel();

    public TaskRow(TaskRef ioRef, boolean even) {
        this.ioRef = ioRef;
        this.addStyleName(even ? "even" : "odd");
        this.panel.add((Widget)new HTML("<strong>" + this.i18n.FormProcessId() + "</strong> " + ioRef.getProcessId()));
        this.panel.add((Widget)new HTML("<strong>" + this.i18n.FormTaskId() + "</strong> " + ioRef.getTaskId()));
        this.focus = this.addFocusHandler((FocusHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.blur = this.addBlurHandler((BlurHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Widget)this.panel);
    }

    public HandlerRegistration getFocus() {
        return this.focus;
    }

    public HandlerRegistration getBlur() {
        return this.blur;
    }

    protected VerticalPanel getPanel() {
        return this.panel;
    }

    public TaskRef getIoRef() {
        return this.ioRef;
    }

    public void onBrowserEvent(Event event) {
        EventHelper.onBrowserEvent((Widget)this, (Event)event);
    }

    public HandlerRegistration addRightClickHandler(RightClickHandler handler) {
        HandlerRegistration reg = EventHelper.addRightClickHandler((Widget)this, (RightClickHandler)handler);
        this.rclickRegs.add(reg);
        return reg;
    }

    public void clearRightClickHandlers() {
        for (HandlerRegistration reg : this.rclickRegs) {
            reg.removeHandler();
        }
        this.rclickRegs.clear();
    }

    protected void showInputs() {
        List inputs = this.ioRef.getInputs();
        this.inputs.clear();
        this.inputs.add((Widget)new HTML("<strong>" + this.i18n.InputsLabel() + "</strong>"));
        if (inputs == null || inputs.isEmpty()) {
            HorizontalPanel hPanel = new HorizontalPanel();
            hPanel.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;"));
            hPanel.add((Widget)new Label(this.i18n.NoInputsLabel()));
            this.inputs.add((Widget)hPanel);
        } else {
            for (TaskPropertyRef input : inputs) {
                HorizontalPanel hPanel = new HorizontalPanel();
                hPanel.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;"));
                hPanel.add((Widget)new Label(input.getName()));
                this.inputs.add((Widget)hPanel);
            }
        }
        this.panel.add((Widget)this.inputs);
    }

    protected void showOutputs() {
        List outputs = this.ioRef.getOutputs();
        this.outputs.clear();
        this.outputs.add((Widget)new HTML("<strong>" + this.i18n.OutputsLabel() + "</strong>"));
        if (outputs == null || outputs.isEmpty()) {
            HorizontalPanel hPanel = new HorizontalPanel();
            hPanel.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;"));
            hPanel.add((Widget)new Label(this.i18n.NoOutputsLabel()));
            this.outputs.add((Widget)hPanel);
        } else {
            for (TaskPropertyRef output : outputs) {
                HorizontalPanel hPanel = new HorizontalPanel();
                hPanel.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;"));
                hPanel.add((Widget)new Label(output.getName()));
                this.outputs.add((Widget)hPanel);
            }
        }
        this.panel.add((Widget)this.outputs);
    }

    protected void showMetaData() {
        Map metaData = this.ioRef.getMetaData();
        this.metaData.clear();
        this.metaData.add((Widget)new HTML("<strong>" + this.i18n.MetaDataLabel() + "</strong>"));
        if (metaData == null || metaData.isEmpty()) {
            HorizontalPanel hPanel = new HorizontalPanel();
            hPanel.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;"));
            hPanel.add((Widget)new Label(this.i18n.NoMetaDataLabel()));
            this.metaData.add((Widget)hPanel);
        } else {
            for (Map.Entry entry : metaData.entrySet()) {
                HorizontalPanel hPanel = new HorizontalPanel();
                hPanel.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;"));
                hPanel.add((Widget)new Label((String)entry.getKey() + "=" + (String)entry.getValue()));
                this.metaData.add((Widget)hPanel);
            }
        }
        this.panel.add((Widget)this.metaData);
    }

    protected void hideInputs() {
        this.panel.remove((Widget)this.inputs);
    }

    protected void hideOutputs() {
        this.panel.remove((Widget)this.outputs);
    }

    protected void hideMetaData() {
        this.panel.remove((Widget)this.metaData);
    }
}

