/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import org.jbpm.services.task.impl.model.OrganizationalEntityImpl;
import org.jbpm.services.task.utils.CollectionUtils;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.task.api.model.AllowedToDelegate;
import org.kie.internal.task.api.model.Delegation;

@Embeddable
public class DelegationImpl
implements Delegation {
    @Enumerated(value=EnumType.STRING)
    private AllowedToDelegate allowedToDelegate;
    @ManyToMany(targetEntity=OrganizationalEntityImpl.class)
    @JoinTable(name="Delegation_delegates", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")})
    private List<OrganizationalEntity> delegates = Collections.emptyList();

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.allowedToDelegate != null) {
            out.writeBoolean(true);
            out.writeUTF(this.allowedToDelegate.toString());
        } else {
            out.writeBoolean(false);
        }
        CollectionUtils.writeOrganizationalEntityList(this.delegates, out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.allowedToDelegate = AllowedToDelegate.valueOf((String)in.readUTF());
        }
        this.delegates = CollectionUtils.readOrganizationalEntityList(in);
    }

    public AllowedToDelegate getAllowed() {
        return this.allowedToDelegate;
    }

    public void setAllowed(AllowedToDelegate allowedToDelegate) {
        this.allowedToDelegate = allowedToDelegate;
    }

    public List<OrganizationalEntity> getDelegates() {
        return this.delegates;
    }

    public void setDelegates(List<OrganizationalEntity> delegates) {
        this.delegates = delegates;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowedToDelegate == null ? 0 : this.allowedToDelegate.hashCode());
        result = 31 * result + CollectionUtils.hashCode(this.delegates);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegationImpl)) {
            return false;
        }
        DelegationImpl other = (DelegationImpl)obj;
        if (this.allowedToDelegate == null ? other.allowedToDelegate != null : !this.allowedToDelegate.equals((Object)other.allowedToDelegate)) {
            return false;
        }
        return CollectionUtils.equals(this.delegates, other.delegates);
    }
}

