/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Embeddable;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.OrganizationalEntityImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.utils.CollectionUtils;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.model.InternalPeopleAssignments;

@Embeddable
public class PeopleAssignmentsImpl
implements InternalPeopleAssignments {
    @ManyToOne
    private UserImpl taskInitiator;
    @ManyToMany(targetEntity=OrganizationalEntityImpl.class)
    @JoinTable(name="PeopleAssignments_PotOwners", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")}, indexes={@Index(name="IDX_PAsPot_Entity", columnList="entity_id"), @Index(name="IDX_PAsPot_Task", columnList="task_id")})
    private List<OrganizationalEntity> potentialOwners = Collections.emptyList();
    @ManyToMany(targetEntity=OrganizationalEntityImpl.class)
    @JoinTable(name="PeopleAssignments_ExclOwners", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")}, indexes={@Index(name="IDX_PAsExcl_Entity", columnList="entity_id"), @Index(name="IDX_PAsExcl_Task", columnList="task_id")})
    private List<OrganizationalEntity> excludedOwners = Collections.emptyList();
    @ManyToMany(targetEntity=OrganizationalEntityImpl.class)
    @JoinTable(name="PeopleAssignments_Stakeholders", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")}, indexes={@Index(name="IDX_PAsStake_Entity", columnList="entity_id"), @Index(name="IDX_PAsStake_Task", columnList="task_id")})
    private List<OrganizationalEntity> taskStakeholders = Collections.emptyList();
    @ManyToMany(targetEntity=OrganizationalEntityImpl.class)
    @JoinTable(name="PeopleAssignments_BAs", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")}, indexes={@Index(name="IDX_PAsBAs_Entity", columnList="entity_id"), @Index(name="IDX_PAsBAs_Task", columnList="task_id")})
    private List<OrganizationalEntity> businessAdministrators = Collections.emptyList();
    @ManyToMany(targetEntity=OrganizationalEntityImpl.class)
    @JoinTable(name="PeopleAssignments_Recipients", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")}, indexes={@Index(name="IDX_PAsRecip_Entity", columnList="entity_id"), @Index(name="IDX_PAsRecip_Task", columnList="task_id")})
    private List<OrganizationalEntity> recipients = Collections.emptyList();

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.taskInitiator != null) {
            out.writeBoolean(true);
            this.taskInitiator.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        CollectionUtils.writeOrganizationalEntityList(this.potentialOwners, out);
        CollectionUtils.writeOrganizationalEntityList(this.excludedOwners, out);
        CollectionUtils.writeOrganizationalEntityList(this.taskStakeholders, out);
        CollectionUtils.writeOrganizationalEntityList(this.businessAdministrators, out);
        CollectionUtils.writeOrganizationalEntityList(this.recipients, out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.taskInitiator = new UserImpl();
            this.taskInitiator.readExternal(in);
        }
        this.potentialOwners = CollectionUtils.readOrganizationalEntityList(in);
        this.excludedOwners = CollectionUtils.readOrganizationalEntityList(in);
        this.taskStakeholders = CollectionUtils.readOrganizationalEntityList(in);
        this.businessAdministrators = CollectionUtils.readOrganizationalEntityList(in);
        this.recipients = CollectionUtils.readOrganizationalEntityList(in);
    }

    public User getTaskInitiator() {
        return this.taskInitiator;
    }

    public void setTaskInitiator(User taskInitiator) {
        this.taskInitiator = TaskDataImpl.convertToUserImpl(taskInitiator);
    }

    public List<OrganizationalEntity> getPotentialOwners() {
        return this.potentialOwners;
    }

    public void setPotentialOwners(List<OrganizationalEntity> potentialOwners) {
        this.potentialOwners = PeopleAssignmentsImpl.convertToPersistentOrganizationalEntity(potentialOwners);
    }

    public List<OrganizationalEntity> getExcludedOwners() {
        return this.excludedOwners;
    }

    public void setExcludedOwners(List<OrganizationalEntity> excludedOwners) {
        this.excludedOwners = PeopleAssignmentsImpl.convertToPersistentOrganizationalEntity(excludedOwners);
    }

    public List<OrganizationalEntity> getTaskStakeholders() {
        return this.taskStakeholders;
    }

    public void setTaskStakeholders(List<OrganizationalEntity> taskStakeholders) {
        this.taskStakeholders = PeopleAssignmentsImpl.convertToPersistentOrganizationalEntity(taskStakeholders);
    }

    public List<OrganizationalEntity> getBusinessAdministrators() {
        return this.businessAdministrators;
    }

    public void setBusinessAdministrators(List<OrganizationalEntity> businessAdministrators) {
        this.businessAdministrators = PeopleAssignmentsImpl.convertToPersistentOrganizationalEntity(businessAdministrators);
    }

    public List<OrganizationalEntity> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<OrganizationalEntity> recipients) {
        this.recipients = PeopleAssignmentsImpl.convertToPersistentOrganizationalEntity(recipients);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CollectionUtils.hashCode(this.businessAdministrators);
        result = 31 * result + CollectionUtils.hashCode(this.excludedOwners);
        result = 31 * result + (this.potentialOwners == null ? 0 : CollectionUtils.hashCode(this.potentialOwners));
        result = 31 * result + CollectionUtils.hashCode(this.recipients);
        result = 31 * result + (this.taskInitiator == null ? 0 : this.taskInitiator.hashCode());
        result = 31 * result + CollectionUtils.hashCode(this.taskStakeholders);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PeopleAssignmentsImpl)) {
            return false;
        }
        PeopleAssignmentsImpl other = (PeopleAssignmentsImpl)obj;
        if (this.taskInitiator == null ? other.taskInitiator != null : !this.taskInitiator.equals(other.taskInitiator)) {
            return false;
        }
        return CollectionUtils.equals(this.businessAdministrators, other.businessAdministrators) && CollectionUtils.equals(this.excludedOwners, other.excludedOwners) && CollectionUtils.equals(this.potentialOwners, other.potentialOwners) && CollectionUtils.equals(this.recipients, other.recipients) && CollectionUtils.equals(this.taskStakeholders, other.taskStakeholders);
    }

    static List<OrganizationalEntity> convertToPersistentOrganizationalEntity(List<OrganizationalEntity> orgEntList) {
        List<OrganizationalEntity> persistentOrgEnts = orgEntList;
        if (persistentOrgEnts != null && !persistentOrgEnts.isEmpty()) {
            persistentOrgEnts = new ArrayList<OrganizationalEntity>(orgEntList.size());
            for (OrganizationalEntity orgEnt : orgEntList) {
                if (orgEnt instanceof UserImpl || orgEnt instanceof GroupImpl) {
                    persistentOrgEnts.add(orgEnt);
                    continue;
                }
                if (orgEnt instanceof User) {
                    persistentOrgEnts.add((OrganizationalEntity)new UserImpl(orgEnt.getId()));
                    continue;
                }
                if (orgEnt instanceof Group) {
                    persistentOrgEnts.add((OrganizationalEntity)new GroupImpl(orgEnt.getId()));
                    continue;
                }
                throw new IllegalStateException("Unknown user or group object: " + orgEnt.getClass().getName());
            }
        }
        return persistentOrgEnts;
    }
}

