/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.persistence;

import java.lang.reflect.Constructor;
import java.util.Collection;
import org.drools.core.command.impl.AbstractInterceptor;
import org.drools.core.runtime.ChainableRunner;
import org.drools.persistence.api.OrderedTransactionSynchronization;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.drools.persistence.api.TransactionManagerHelper;
import org.jbpm.services.task.persistence.JPATaskPersistenceContextManager;
import org.kie.api.KieBase;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.RequestContext;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.TaskPersistenceContextManager;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.exception.TaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTransactionInterceptor
extends AbstractInterceptor {
    private static Logger logger = LoggerFactory.getLogger(TaskTransactionInterceptor.class);
    private static String SPRING_TM_CLASSNAME = "org.springframework.transaction.support.AbstractPlatformTransactionManager";
    private ChainableRunner commandService;
    private TransactionManager txm;
    private TaskPersistenceContextManager tpm;
    private boolean eagerDisabled = Boolean.getBoolean("jbpm.ht.eager.disabled");

    public TaskTransactionInterceptor(Environment environment) {
        this.initTransactionManager(environment);
    }

    public synchronized RequestContext execute(Executable executable, RequestContext ctx) {
        boolean transactionOwner = false;
        try {
            transactionOwner = this.txm.begin();
            this.tpm.beginCommandScopedEntityManager();
            TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)this.txm, (OrderedTransactionSynchronization)new TaskSynchronizationImpl(this));
            RequestContext context = this.createContext();
            this.executeNext(executable, (Context)context);
            ctx.setResult(context.getResult());
            this.postInit(ctx.getResult());
            this.txm.commit(transactionOwner);
            return ctx;
        }
        catch (TaskException e) {
            if (transactionOwner) {
                this.rollbackTransaction((Exception)((Object)e), transactionOwner);
                e.setRecoverable(false);
                throw e;
            }
            throw e;
        }
        catch (RuntimeException re) {
            this.rollbackTransaction(re, transactionOwner);
            throw re;
        }
        catch (Exception t1) {
            this.rollbackTransaction(t1, transactionOwner);
            throw new RuntimeException("Wrapped exception see cause", t1);
        }
    }

    private void rollbackTransaction(Exception t1, boolean transactionOwner) {
        try {
            logger.warn("Could not commit session", (Throwable)t1);
            this.txm.rollback(transactionOwner);
        }
        catch (Exception t2) {
            logger.error("Could not rollback", (Throwable)t2);
            throw new RuntimeException("Could not commit session or rollback", t2);
        }
    }

    public void addInterceptor(ChainableRunner interceptor) {
        interceptor.setNext((ExecutableRunner)(this.commandService == null ? this : this.commandService));
        this.commandService = interceptor;
    }

    public RequestContext createContext() {
        TaskPersistenceContext persistenceContext = this.tpm.getPersistenceContext();
        persistenceContext.joinTransaction();
        return new TransactionContext(persistenceContext);
    }

    public void initTransactionManager(Environment env) {
        Object tm = env.get("org.kie.transaction.TransactionManager");
        if (env.get("org.kie.api.persistence.TaskPersistenceContextManager") != null && env.get("org.kie.transaction.TransactionManager") != null) {
            this.txm = (TransactionManager)tm;
            this.tpm = (TaskPersistenceContextManager)env.get("org.kie.api.persistence.TaskPersistenceContextManager");
        } else {
            if (tm != null && this.isSpringTransactionManager(tm.getClass())) {
                try {
                    logger.debug("Instantiating KieSpringTransactionManager");
                    Class<?> cls = Class.forName("org.kie.spring.persistence.KieSpringTransactionManager");
                    Constructor<?> con = cls.getConstructors()[0];
                    this.txm = (TransactionManager)con.newInstance(tm);
                    env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
                    cls = Class.forName("org.kie.spring.persistence.KieSpringTaskJpaManager");
                    con = cls.getConstructors()[0];
                    this.tpm = (TaskPersistenceContextManager)con.newInstance(env);
                }
                catch (Exception e) {
                    logger.warn("Could not instantiate DroolsSpringTransactionManager");
                    throw new RuntimeException("Could not instantiate org.kie.container.spring.beans.persistence.DroolsSpringTransactionManager", e);
                }
            }
            logger.debug("Instantiating JtaTransactionManager");
            this.txm = TransactionManagerFactory.get().newTransactionManager(env);
            env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
            try {
                this.tpm = new JPATaskPersistenceContextManager(env);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating JPATaskPersistenceContextManager", e);
            }
            env.set("org.kie.api.persistence.TaskPersistenceContextManager", (Object)this.tpm);
            env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
        }
    }

    public boolean isSpringTransactionManager(Class<?> clazz) {
        if (SPRING_TM_CLASSNAME.equals(clazz.getName())) {
            return true;
        }
        if (clazz.getSuperclass() != null) {
            return this.isSpringTransactionManager(clazz.getSuperclass());
        }
        return false;
    }

    private void postInit(Object result) {
        if (result instanceof Task) {
            Task task = (Task)result;
            if (task != null && !this.eagerDisabled) {
                task.getNames().size();
                task.getDescriptions().size();
                task.getSubjects().size();
                task.getPeopleAssignments().getBusinessAdministrators().size();
                task.getPeopleAssignments().getPotentialOwners().size();
                ((InternalPeopleAssignments)task.getPeopleAssignments()).getRecipients().size();
                ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners().size();
                ((InternalPeopleAssignments)task.getPeopleAssignments()).getTaskStakeholders().size();
                task.getTaskData().getAttachments().size();
                task.getTaskData().getComments().size();
                ((InternalTask)task).getDeadlines().getStartDeadlines().size();
                ((InternalTask)task).getDeadlines().getEndDeadlines().size();
                if (((InternalTask)task).getDelegation() != null) {
                    ((InternalTask)task).getDelegation().getDelegates().size();
                }
            }
        } else if (result instanceof Collection) {
            ((Collection)result).size();
        }
    }

    private static class TaskSynchronizationImpl
    extends OrderedTransactionSynchronization {
        TaskTransactionInterceptor service;

        public TaskSynchronizationImpl(TaskTransactionInterceptor service) {
            super(Integer.valueOf(1), "TaskService-" + ((Object)((Object)service)).toString());
            this.service = service;
        }

        public void afterCompletion(int status) {
            this.service.tpm.endCommandScopedEntityManager();
        }

        public void beforeCompletion() {
        }
    }

    public class TransactionContext
    implements TaskContext,
    RequestContext {
        private final TaskPersistenceContext persistenceContext;

        public TransactionContext(TaskPersistenceContext persistenceContext) {
            this.persistenceContext = persistenceContext;
        }

        public void set(String identifier, Object value) {
            TaskTransactionInterceptor.this.txm.putResource((Object)identifier, value);
        }

        public void remove(String identifier) {
        }

        public boolean has(String identifier) {
            return false;
        }

        public String getName() {
            return null;
        }

        public Object get(String identifier) {
            return TaskTransactionInterceptor.this.txm.getResource((Object)identifier);
        }

        public void setPersistenceContext(TaskPersistenceContext context) {
        }

        public TaskPersistenceContext getPersistenceContext() {
            return this.persistenceContext;
        }

        public UserGroupCallback getUserGroupCallback() {
            return null;
        }

        public Task loadTaskVariables(Task task) {
            return task;
        }

        public Object getResult() {
            return this.get("Result");
        }

        public void setResult(Object result) {
            this.set("Result", result);
        }

        public RequestContext with(KieBase kieBase) {
            throw new UnsupportedOperationException("org.jbpm.services.task.persistence.TaskTransactionInterceptor.TransactionContext.with -> TODO");
        }

        public RequestContext with(KieSession kieSession) {
            throw new UnsupportedOperationException("org.jbpm.services.task.persistence.TaskTransactionInterceptor.TransactionContext.with -> TODO");
        }

        public Context getConversationContext() {
            throw new UnsupportedOperationException("org.jbpm.services.task.persistence.TaskTransactionInterceptor.TransactionContext.getConversationContext -> TODO");
        }

        public Context getApplicationContext() {
            throw new UnsupportedOperationException("org.jbpm.services.task.persistence.TaskTransactionInterceptor.TransactionContext.getApplicationContext -> TODO");
        }
    }
}

