/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.mina;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.jbpm.task.service.TaskServer;

public abstract class BaseMinaTaskServer
extends TaskServer {
    private final int port;
    IoHandlerAdapter handler;
    IoAcceptor acceptor;
    volatile boolean running;
    String localInterface;

    public BaseMinaTaskServer(IoHandlerAdapter handler, int port) {
        this(handler, port, "127.0.0.1");
    }

    public BaseMinaTaskServer(IoHandlerAdapter handler, int port, String localInterface) {
        this.handler = handler;
        this.port = port;
        this.localInterface = localInterface;
    }

    public void run() {
        try {
            this.start();
            while (this.running) {
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                throw new RuntimeException("Could not start human task server, address already in use, is it possible that another instance of the task server is already running?");
            }
            throw new RuntimeException("Server Exception with class " + ((Object)((Object)this)).getClass() + " using port " + this.port, e);
        }
    }

    public void start() throws IOException {
        this.acceptor = new NioSocketAcceptor();
        this.acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        this.acceptor.setHandler((IoHandler)this.handler);
        this.acceptor.getSessionConfig().setReadBufferSize(2048);
        this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, 10);
        ((SocketSessionConfig)this.acceptor.getSessionConfig()).setSoLinger(0);
        this.acceptor.bind((SocketAddress)new InetSocketAddress(this.localInterface, this.port));
        this.running = true;
    }

    public IoAcceptor getIoAcceptor() {
        return this.acceptor;
    }

    public void stop() {
        this.running = false;
        this.acceptor.dispose();
    }

    public boolean isRunning() {
        return this.running;
    }
}

