/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.task.AccessType;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Content;
import org.jbpm.task.ContentData;
import org.jbpm.task.Group;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.exception.PermissionDeniedException;
import org.jbpm.task.impl.factories.TaskFactory;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.junit.Assert;
import org.junit.Test;

public abstract class LifeCycleBaseTest
extends BaseTest {
    @Test
    public void testNewTaskWithNoPotentialOwners() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
        Assert.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    @Test
    public void testNewTaskWithSinglePotentialOwner() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Bobba Fet", (Object)task1.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testNewTaskWithContent() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        ContentData data = ContentMarshallerHelper.marshal((Object)"content", null);
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, data);
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getDocumentAccessType());
        Assert.assertEquals((Object)"java.lang.String", (Object)task1.getTaskData().getDocumentType());
        long contentId = task1.getTaskData().getDocumentContentId();
        Assert.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Content content = this.taskService.getContentById(contentId);
        Object unmarshalledObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        Assert.assertEquals((Object)"content", (Object)unmarshalledObject.toString());
    }

    public void testNewTaskWithMapContent() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        variablesMap.put("key1", "value1");
        variablesMap.put("key2", null);
        variablesMap.put("key3", "value3");
        ContentData data = ContentMarshallerHelper.marshal(variablesMap, null);
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, data);
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getDocumentAccessType());
        Assert.assertEquals((Object)"java.util.HashMap", (Object)task1.getTaskData().getDocumentType());
        long contentId = task1.getTaskData().getDocumentContentId();
        Assert.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Content content = this.taskService.getContentById(contentId);
        Object unmarshalledObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        if (!(unmarshalledObject instanceof Map)) {
            Assert.fail((String)"The variables should be a Map");
        }
        Map unmarshalledvars = (Map)unmarshalledObject;
        Assert.assertEquals((Object)"value1", unmarshalledvars.get("key1"));
        Assert.assertNull(unmarshalledvars.get("key2"));
        Assert.assertEquals((Object)"value3", unmarshalledvars.get("key3"));
    }

    @Test
    public void testNewTaskWithLargeContent() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        String largeContent = "";
        for (int i = 0; i < 1000; ++i) {
            largeContent = largeContent + i + "xxxxxxxxx";
        }
        ContentData data = ContentMarshallerHelper.marshal((Object)largeContent, null);
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, data);
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getDocumentAccessType());
        Assert.assertEquals((Object)"java.lang.String", (Object)task1.getTaskData().getDocumentType());
        long contentId = task1.getTaskData().getDocumentContentId();
        Assert.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Content content = this.taskService.getContentById(contentId);
        Object unmarshalledObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        Assert.assertEquals((Object)largeContent, (Object)unmarshalledObject.toString());
    }

    @Test
    public void testClaimWithMultiplePotentialOwners() throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'),new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        this.taskService.claim(taskId, "Darth Vader");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testClaimWithGroupAssignee() throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Knights Templer' )], businessAdministrators = [ new User('Administrator') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        this.taskService.claim(taskId, "Darth Vader");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testStartFromReadyStateWithPotentialOwner() throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        this.taskService.start(taskId, "Darth Vader");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testStartFromReadyStateWithIncorrectPotentialOwner() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        PermissionDeniedException denied = null;
        try {
            this.taskService.start(taskId, "Tony Stark");
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        Assert.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        Assert.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    @Test
    public void testStartFromReserved() throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Bobba Fet", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.start(taskId, "Bobba Fet");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Bobba Fet", (Object)task1.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testStartFromReservedWithIncorrectUser() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Bobba Fet", (Object)task1.getTaskData().getActualOwner().getId());
        PermissionDeniedException denied = null;
        try {
            this.taskService.start(taskId, "Tony Stark");
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        Assert.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Bobba Fet", (Object)task1.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testStop() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.start(taskId, "Darth Vader");
        this.taskService.getTaskById(taskId);
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.stop(taskId, "Darth Vader");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testStopWithIncorrectUser() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        PermissionDeniedException denied = null;
        try {
            this.taskService.stop(taskId, "Bobba Fet");
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        Assert.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testReleaseFromInprogress() throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.start(taskId, "Darth Vader");
        this.taskService.getTaskById(taskId);
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.release(taskId, "Darth Vader");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        Assert.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseFromReserved() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.release(taskId, "Darth Vader");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        Assert.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    @Test
    public void testReleaseWithIncorrectUser() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        PermissionDeniedException denied = null;
        try {
            this.taskService.release(taskId, "Bobba Fet");
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        Assert.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testSuspendFromReady() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.getTaskById(taskId);
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        Assert.assertNull((Object)task1.getTaskData().getActualOwner());
        this.taskService.suspend(taskId, "Darth Vader");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getPreviousStatus());
        Assert.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    @Test
    public void testSuspendFromReserved() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.suspend(taskId, "Darth Vader");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getPreviousStatus());
        Assert.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testSuspendFromReservedWithIncorrectUser() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        PermissionDeniedException denied = null;
        try {
            this.taskService.suspend(taskId, "Bobba Fet");
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        Assert.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testResumeFromReady() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        Assert.assertNull((Object)task1.getTaskData().getActualOwner());
        this.taskService.suspend(taskId, "Darth Vader");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getPreviousStatus());
        Assert.assertNull((Object)task1.getTaskData().getActualOwner());
        this.taskService.resume(taskId, "Darth Vader");
        Task task3 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task3.getTaskData().getStatus());
        Assert.assertEquals((Object)Status.Suspended, (Object)task3.getTaskData().getPreviousStatus());
        Assert.assertNull((Object)task3.getTaskData().getActualOwner());
    }

    @Test
    public void testResumeFromReserved() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.suspend(taskId, "Darth Vader");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getPreviousStatus());
        Assert.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
        this.taskService.resume(taskId, "Darth Vader");
        Task task3 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task3.getTaskData().getStatus());
        Assert.assertEquals((Object)Status.Suspended, (Object)task3.getTaskData().getPreviousStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task3.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testResumeFromReservedWithIncorrectUser() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        PermissionDeniedException denied = null;
        try {
            this.taskService.suspend(taskId, "Bobba Fet");
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        Assert.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testSkipFromReady() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = true} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.skip(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Obsolete, (Object)task1.getTaskData().getStatus());
        Assert.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    @Test
    public void testSkipFromReserved() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = true} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Darth Vader");
        this.taskService.skip(taskId, "Darth Vader");
        this.taskService.getTaskById(taskId);
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Obsolete, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testDelegateFromReady() throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.delegate(taskId, "Darth Vader", "Tony Stark");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(new User("Darth Vader")));
        Assert.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(new User("Tony Stark")));
        Assert.assertEquals((Object)"Tony Stark", (Object)task2.getTaskData().getActualOwner().getId());
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    @Test
    public void testDelegateFromReserved() throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.delegate(taskId, "Darth Vader", "Tony Stark");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(new User("Darth Vader")));
        Assert.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(new User("Tony Stark")));
        Assert.assertEquals((Object)"Tony Stark", (Object)task2.getTaskData().getActualOwner().getId());
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    @Test
    public void testDelegateFromReservedWithIncorrectUser() throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        PermissionDeniedException denied = null;
        try {
            this.taskService.delegate(taskId, "Bobba Fet", "Tony Stark");
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        Assert.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(new User("Darth Vader")));
        Assert.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(new User("Tony Stark")));
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReady() throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.forward(taskId, "Darth Vader", "Tony Stark");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains("Darth Vader"));
        Assert.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains("Tony Stark"));
        Assert.assertNull((Object)task2.getTaskData().getActualOwner());
        Assert.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    @Test
    public void testForwardFromReserved() throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.forward(taskId, "Darth Vader", "Tony Stark");
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(new User("Darth Vader")));
        Assert.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(new User("Tony Stark")));
        Assert.assertNull((Object)task2.getTaskData().getActualOwner());
        Assert.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    @Test
    public void testForwardFromReservedWithIncorrectUser() throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        PermissionDeniedException denied = null;
        try {
            this.taskService.forward(taskId, "Bobba Fet", "Tony Stark");
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        Assert.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(new User("Darth Vader")));
        Assert.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(new User("Tony Stark")));
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
        Assert.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    @Test
    public void testComplete() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.complete(taskId, "Darth Vader", null);
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Completed, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testCompleteWithIncorrectUser() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        PermissionDeniedException denied = null;
        try {
            this.taskService.complete(taskId, "Bobba Fet", null);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        Assert.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testCompleteWithContent() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("content", "content");
        this.taskService.complete(taskId, "Darth Vader", params);
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)AccessType.Inline, (Object)task2.getTaskData().getOutputAccessType());
        Assert.assertEquals((Object)"java.util.HashMap", (Object)task2.getTaskData().getOutputType());
        long contentId = task2.getTaskData().getOutputContentId();
        Assert.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Content content = this.taskService.getContentById(contentId);
        Map unmarshalledObject = (Map)ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        Assert.assertEquals((Object)"content", unmarshalledObject.get("content"));
    }

    @Test
    public void testCompleteWithResults() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("content", "content");
        this.taskService.complete(taskId, "Darth Vader", params);
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)AccessType.Inline, (Object)task2.getTaskData().getOutputAccessType());
        Assert.assertEquals((Object)"java.util.HashMap", (Object)task2.getTaskData().getOutputType());
        long contentId = task2.getTaskData().getOutputContentId();
        Assert.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Content content = this.taskService.getContentById(contentId);
        Map unmarshalledObject = (Map)ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        Assert.assertEquals((Object)"content", unmarshalledObject.get("content"));
    }

    @Test
    public void testFail() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.fail(taskId, "Darth Vader", null);
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Failed, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testFailWithIncorrectUser() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        PermissionDeniedException denied = null;
        try {
            this.taskService.fail(taskId, "Bobba Fet", null);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        Assert.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
    }

    @Test
    public void testFailWithContent() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.start(taskId, "Darth Vader");
        this.taskService.getTaskById(taskId);
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        HashMap<String, String> faultData = new HashMap<String, String>();
        faultData.put("faultType", "type");
        faultData.put("faultName", "faultName");
        faultData.put("content", "content");
        this.taskService.fail(taskId, "Darth Vader", faultData);
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Failed, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)AccessType.Inline, (Object)task2.getTaskData().getFaultAccessType());
        Assert.assertEquals((Object)"type", (Object)task2.getTaskData().getFaultType());
        Assert.assertEquals((Object)"faultName", (Object)task2.getTaskData().getFaultName());
        long contentId = task2.getTaskData().getFaultContentId();
        Assert.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Content content = this.taskService.getContentById(contentId);
        Map unmarshalledContent = (Map)ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        Assert.assertEquals((Object)"content", unmarshalledContent.get("content"));
    }

    @Test
    public void testRemoveNotInRecipientList() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ],";
        str = str + "recipients = [new User('Bobba Fet') ] }),";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })"), null, (boolean)false);
        if (task.getPeopleAssignments() != null && task.getPeopleAssignments().getBusinessAdministrators() != null) {
            ArrayList<User> businessAdmins = new ArrayList<User>();
            businessAdmins.add(new User("Administrator"));
            businessAdmins.addAll(task.getPeopleAssignments().getBusinessAdministrators());
            task.getPeopleAssignments().setBusinessAdministrators(businessAdmins);
        }
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List myRecipientTasks = this.taskService.getTasksAssignedAsRecipient("Jabba Hutt", "en-UK");
        Assert.assertNotNull((Object)myRecipientTasks);
        Assert.assertEquals((long)0L, (long)myRecipientTasks.size());
        List myPotentialTasks = this.taskService.getTasksAssignedAsPotentialOwner("Jabba Hutt", "en-UK");
        Assert.assertNotNull((Object)myPotentialTasks);
        Assert.assertEquals((long)0L, (long)myPotentialTasks.size());
        try {
            this.taskService.remove(taskId, "Jabba Hutt");
            Assert.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertTrue((boolean)task1.getPeopleAssignments().getRecipients().contains(new User("Bobba Fet")));
    }

    @Test
    public void testNominateOnOtherThanCreated() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ new User('Darth Vader') ] ,";
        str = str + " potentialOwners = [ new User('Darth Vader'), new User('Bobba Fet') ] } ),";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })"), null, (boolean)false);
        if (task.getPeopleAssignments() != null && task.getPeopleAssignments().getBusinessAdministrators() != null) {
            ArrayList<User> businessAdmins = new ArrayList<User>();
            businessAdmins.add(new User("Administrator"));
            businessAdmins.addAll(task.getPeopleAssignments().getBusinessAdministrators());
            task.getPeopleAssignments().setBusinessAdministrators(businessAdmins);
        }
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.start(taskId, "Bobba Fet");
        try {
            ArrayList<User> potentialOwners = new ArrayList<User>();
            potentialOwners.add(new User("Bobba Fet"));
            this.taskService.nominate(taskId, "Darth Vader", potentialOwners);
            Assert.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(new User("Darth Vader")));
        Assert.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(new User("Bobba Fet")));
    }

    @Test
    public void testNominateWithIncorrectUser() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ new User('Bobba Fet') ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        try {
            ArrayList<User> potentialOwners = new ArrayList<User>(1);
            potentialOwners.add(new User("Jabba Hutt"));
            this.taskService.nominate(taskId, "Darth Vader", potentialOwners);
            Assert.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertTrue((boolean)task1.getPeopleAssignments().getBusinessAdministrators().contains(new User("Bobba Fet")));
        Assert.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
    }

    @Test
    public void testNominateToUser() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ new User('Darth Vader'), new User('Bobba Fet') ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        ArrayList<User> potentialOwners = new ArrayList<User>(1);
        potentialOwners.add(new User("Jabba Hutt"));
        this.taskService.nominate(taskId, "Darth Vader", potentialOwners);
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)task1.getTaskData().getActualOwner().getId(), (Object)"Jabba Hutt");
        Assert.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Reserved);
    }

    @Test
    public void testNominateToGroup() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ new User('Darth Vader'), new User('Bobba Fet') ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        ArrayList<Group> potentialGroups = new ArrayList<Group>();
        potentialGroups.add(new Group("Knights Templer"));
        this.taskService.nominate(taskId, "Darth Vader", potentialGroups);
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(new Group("Knights Templer")));
        Assert.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Ready);
    }

    @Test
    public void testActivate() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { ";
        str = str + "businessAdministrators = [ new User('Darth Vader') ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.activate(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Ready);
    }

    @Test
    public void testActivateWithIncorrectUser() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [ new User('Darth Vader'), new User('Bobba Fet') ], ";
        str = str + "businessAdministrators = [ new User('Jabba Hutt') ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        try {
            this.taskService.activate(taskId, "Darth Vader");
            Assert.fail((String)"Shouldn't have succeded");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testActivateFromIncorrectStatus() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [ new User('Darth Vader'), new User('Bobba Fet') ], ";
        str = str + "businessAdministrators = [ new User('Jabba Hutt') ] } ),";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })"), null, (boolean)false);
        if (task.getPeopleAssignments() != null && task.getPeopleAssignments().getBusinessAdministrators() != null) {
            ArrayList<User> businessAdmins = new ArrayList<User>();
            businessAdmins.add(new User("Administrator"));
            businessAdmins.addAll(task.getPeopleAssignments().getBusinessAdministrators());
            task.getPeopleAssignments().setBusinessAdministrators(businessAdmins);
        }
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        try {
            this.taskService.activate(taskId, "Darth Vader");
            Assert.fail((String)"Shouldn't have succeded");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testExitFromReady() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], businessAdministrators = [ new User('Administrator')] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        this.taskService.exit(taskId, "Administrator");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Exited, (Object)task1.getTaskData().getStatus());
    }

    @Test
    public void testExitFromReserved() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], businessAdministrators = [ new User('Administrator')] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        this.taskService.exit(taskId, "Administrator");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Exited, (Object)task1.getTaskData().getStatus());
    }

    @Test
    public void testExitFromInProgress() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], businessAdministrators = [ new User('admin')] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        this.taskService.start(taskId, "Bobba Fet");
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task.getTaskData().getStatus());
        this.taskService.exit(taskId, "Administrator");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Exited, (Object)task1.getTaskData().getStatus());
    }

    @Test
    public void testExitFromSuspended() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], businessAdministrators = [ new User('Administrator')] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        this.taskService.suspend(taskId, "Bobba Fet");
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Suspended, (Object)task.getTaskData().getStatus());
        this.taskService.exit(taskId, "Administrator");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Exited, (Object)task1.getTaskData().getStatus());
    }

    @Test
    public void testExitPermissionDenied() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new User('Darth Vader') ], businessAdministrators = [ new User('Administrator')] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        try {
            this.taskService.exit(taskId, "Darth Vader");
            Assert.fail((String)"Non admin user can't exit a task");
        }
        catch (PermissionDeniedException e) {
            // empty catch block
        }
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
    }

    @Test
    public void testExitNotAvailableToUsers() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], businessAdministrators = [ new User('Administrator')] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        this.taskService.exit(taskId, "Administrator");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Exited, (Object)task1.getTaskData().getStatus());
        List exitedTasks = this.taskService.getTasksAssignedAsPotentialOwner("Bobba Fet", "en-UK");
        Assert.assertEquals((long)0L, (long)exitedTasks.size());
    }

    @Test
    public void testClaimConflictAndRetry() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('salaboy'), new User('Bobba Fet') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        this.taskService.addTask(TaskFactory.evalTask((Reader)new StringReader(str)), new HashMap());
        List salaboyTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        Long salaboyTaskId = ((TaskSummary)salaboyTasks.get(0)).getId();
        Task salaboyTask = this.taskService.getTaskById(salaboyTaskId.longValue());
        Assert.assertEquals((Object)Status.Ready, (Object)salaboyTask.getTaskData().getStatus());
        List bobbaTasks = this.taskService.getTasksAssignedAsPotentialOwner("Bobba Fet", "en-UK");
        Long bobbaTaskId = ((TaskSummary)bobbaTasks.get(0)).getId();
        Assert.assertEquals((Object)bobbaTaskId, (Object)salaboyTaskId);
        Task bobbaTask = this.taskService.getTaskById(bobbaTaskId.longValue());
        Assert.assertEquals((Object)Status.Ready, (Object)bobbaTask.getTaskData().getStatus());
        this.taskService.claim(bobbaTask.getId().longValue(), "Bobba Fet");
        try {
            this.taskService.claim(salaboyTask.getId().longValue(), "salaboy");
        }
        catch (PermissionDeniedException ex) {
            Assert.assertNotNull((Object)((Object)ex));
        }
    }

    @Test
    public void testClaimNextAvailable() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('salaboy'), new User('Bobba Fet') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        this.taskService.addTask(TaskFactory.evalTask((Reader)new StringReader(str)), new HashMap());
        this.taskService.claimNextAvailable("Bobba Fet", "en-UK");
        ArrayList<Status> status = new ArrayList<Status>();
        status.add(Status.Ready);
        List salaboyTasks = this.taskService.getTasksAssignedAsPotentialOwnerByStatus("salaboy", status, "en-UK");
        Assert.assertEquals((long)0L, (long)salaboyTasks.size());
    }
}

