/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.identity;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Properties;
import org.jbpm.task.identity.DBUserGroupCallbackImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DBUserGroupCallbackImplTest {
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    private PoolingDataSource pds;
    private Properties props;

    @Before
    public void setup() {
        Properties dsProps = this.loadDataSourceProperties();
        this.pds = new PoolingDataSource();
        this.pds.setUniqueName("jdbc/taskDS");
        this.pds.setClassName(dsProps.getProperty("className"));
        this.pds.setMaxPoolSize(Integer.parseInt(dsProps.getProperty("maxPoolSize")));
        this.pds.setAllowLocalTransactions(Boolean.parseBoolean(dsProps.getProperty("allowLocalTransactions")));
        for (String propertyName : new String[]{"user", "password"}) {
            this.pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
        }
        this.setDatabaseSpecificDataSourceProperties(this.pds, dsProps);
        this.pds.init();
        this.prepareDb();
        this.props = new Properties();
        this.props.setProperty("db.ds.jndi.name", "jdbc/taskDS");
        this.props.setProperty("db.user.query", "select userId from Users where userId = ?");
        this.props.setProperty("db.roles.query", "select groupId from Groups where groupId = ?");
        this.props.setProperty("db.user.roles.query", "select groupId from Groups where userId = ?");
    }

    protected Properties loadDataSourceProperties() {
        InputStream propsInputStream = this.getClass().getResourceAsStream(DATASOURCE_PROPERTIES);
        Properties dsProps = new Properties();
        if (propsInputStream != null) {
            try {
                dsProps.load(propsInputStream);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return dsProps;
    }

    protected void prepareDb() {
        try {
            Connection conn = this.pds.getConnection();
            String createUserTableSql = "create table Users (userId varchar(255));";
            PreparedStatement st = conn.prepareStatement(createUserTableSql);
            st.execute();
            String createGroupTableSql = "create table Groups (groupId varchar(255), userId varchar(255));";
            st = conn.prepareStatement(createGroupTableSql);
            st.execute();
            String insertUser = "insert into Users (userId) values (?);";
            st = conn.prepareStatement(insertUser);
            st.setString(1, "john");
            st.execute();
            String insertGroup = "insert into Groups (groupId, userId) values (?, ?);";
            st = conn.prepareStatement(insertGroup);
            st.setString(1, "PM");
            st.setString(2, "john");
            st.execute();
            st.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void cleanDb() {
        try {
            Connection conn = this.pds.getConnection();
            String dropUserTableSql = "drop table Users;";
            PreparedStatement st = conn.prepareStatement(dropUserTableSql);
            st.execute();
            String dropGroupTableSql = "drop table Groups;";
            st = conn.prepareStatement(dropGroupTableSql);
            st.execute();
            st.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @After
    public void cleanup() {
        this.cleanDb();
        this.pds.close();
    }

    @Test
    public void testUserExists() {
        DBUserGroupCallbackImpl callback = new DBUserGroupCallbackImpl(this.props);
        boolean exists = callback.existsUser("john");
        Assert.assertTrue((boolean)exists);
    }

    @Test
    public void testGroupExists() {
        DBUserGroupCallbackImpl callback = new DBUserGroupCallbackImpl(this.props);
        boolean exists = callback.existsGroup("PM");
        Assert.assertTrue((boolean)exists);
    }

    @Test
    public void testUserGroups() {
        DBUserGroupCallbackImpl callback = new DBUserGroupCallbackImpl(this.props);
        List groups = callback.getGroupsForUser("john", null, null);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"PM", groups.get(0));
    }

    @Test
    public void testUserNotExists() {
        DBUserGroupCallbackImpl callback = new DBUserGroupCallbackImpl(this.props);
        boolean exists = callback.existsUser("mike");
        Assert.assertFalse((boolean)exists);
    }

    @Test
    public void testGroupNotExists() {
        DBUserGroupCallbackImpl callback = new DBUserGroupCallbackImpl(this.props);
        boolean exists = callback.existsGroup("HR");
        Assert.assertFalse((boolean)exists);
    }

    @Test
    public void testNoUserGroups() {
        DBUserGroupCallbackImpl callback = new DBUserGroupCallbackImpl(this.props);
        List groups = callback.getGroupsForUser("mike", null, null);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)0L, (long)groups.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConfiguration() {
        Properties invalidProps = new Properties();
        DBUserGroupCallbackImpl callback = new DBUserGroupCallbackImpl(invalidProps);
        callback.getGroupsForUser("mike", null, null);
        Assert.fail((String)"Should fail as it does not have valid configuration");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidArgument() {
        DBUserGroupCallbackImpl callback = new DBUserGroupCallbackImpl(this.props);
        callback.getGroupsForUser(null, null, null);
        Assert.fail((String)"Should fail as it does not have valid configuration");
    }

    private void setDatabaseSpecificDataSourceProperties(PoolingDataSource pds, Properties dsProps) {
        String driverClass = dsProps.getProperty("driverClassName");
        if (driverClass.startsWith("org.h2")) {
            for (String propertyName : new String[]{"url", "driverClassName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
        } else if (driverClass.startsWith("oracle")) {
            pds.getDriverProperties().put("driverType", "thin");
            pds.getDriverProperties().put("URL", dsProps.getProperty("url"));
        } else if (driverClass.startsWith("com.ibm.db2")) {
            for (String propertyName : new String[]{"databaseName", "portNumber", "serverName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
            pds.getDriverProperties().put("driverType", "4");
        } else if (driverClass.startsWith("com.microsoft")) {
            for (String propertyName : new String[]{"serverName", "portNumber", "databaseName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
            pds.getDriverProperties().put("URL", dsProps.getProperty("url"));
            pds.getDriverProperties().put("selectMethod", "cursor");
            pds.getDriverProperties().put("InstanceName", "MSSQL01");
        } else if (driverClass.startsWith("com.mysql")) {
            for (String propertyName : new String[]{"databaseName", "serverName", "portNumber", "url"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
        } else if (driverClass.startsWith("com.sybase")) {
            for (String propertyName : new String[]{"databaseName", "portNumber", "serverName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
            pds.getDriverProperties().put("REQUEST_HA_SESSION", "false");
            pds.getDriverProperties().put("networkProtocol", "Tds");
        } else if (driverClass.startsWith("org.postgresql")) {
            for (String propertyName : new String[]{"databaseName", "portNumber", "serverName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
        } else {
            throw new RuntimeException("Unknown driver class: " + driverClass);
        }
    }
}

