/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.inject.Inject;
import org.jbpm.task.LifeCycleBaseTest;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.api.TaskServiceEntryPoint;
import org.jbpm.task.utils.MVELUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTest {
    protected static Logger logger = LoggerFactory.getLogger(BaseTest.class);
    protected static boolean usersLoaded = false;
    @Inject
    protected TaskServiceEntryPoint taskService;
    protected static final String mySubject = "My Subject";
    protected static final String myBody = "My Body";

    @Before
    protected void setUp() {
        if (!usersLoaded) {
            try {
                MockUserInfo userInfo = new MockUserInfo();
                this.taskService.setUserInfo((UserInfo)userInfo);
                this.taskService.addUser(new User("Administrator"));
                usersLoaded = true;
            }
            catch (Exception ex) {
                java.util.logging.Logger.getLogger(LifeCycleBaseTest.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @After
    public void tearDown() {
        int removeAllTasks = this.taskService.removeAllTasks();
    }

    @AfterClass
    public static void tearDownClass() {
        usersLoaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map fillUsersOrGroups(String mvelFileName) throws Exception {
        HashMap vars = new HashMap();
        Reader reader = null;
        Map result = null;
        try {
            reader = new InputStreamReader(BaseTest.class.getResourceAsStream(mvelFileName));
            result = (Map)MVELUtils.eval((Reader)reader, vars);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return result;
    }

    protected static Map<String, String> fillMarshalSubjectAndBodyParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subject", mySubject);
        params.put("body", myBody);
        return params;
    }

    protected static void checkContentSubjectAndBody(Object unmarshalledObject) {
        Assert.assertTrue((String)"Content is null.", (unmarshalledObject != null && unmarshalledObject.toString() != null ? 1 : 0) != 0);
        String content = unmarshalledObject.toString();
        boolean match = false;
        if ("{body=My Body, subject=My Subject}".equals(content) || "{subject=My Subject, body=My Body}".equals(content)) {
            match = true;
        }
        Assert.assertTrue((String)"Content does not match.", (boolean)match);
    }

    protected void printTestName() {
        System.out.println("Running " + this.getClass().getSimpleName() + "." + Thread.currentThread().getStackTrace()[2].getMethodName());
    }
}

