/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.commands;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Group;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.commands.TaskCommand;
import org.jbpm.task.commands.TaskContext;
import org.jbpm.task.events.AfterTaskReleasedEvent;
import org.jbpm.task.events.BeforeTaskReleasedEvent;
import org.jbpm.task.exception.PermissionDeniedException;
import org.kie.command.Context;

@Transactional
public class ReleaseTaskCommand
extends TaskCommand {
    public ReleaseTaskCommand(long taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskReleasedEvent>(){}}).fire((Object)task);
        boolean ownerAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
        boolean adminAllowed = this.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators());
        if (!ownerAllowed && !adminAllowed) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if (task.getTaskData().getStatus().equals((Object)Status.Reserved) || task.getTaskData().getStatus().equals((Object)Status.InProgress)) {
            task.getTaskData().setStatus(Status.Ready);
            task.getTaskData().setActualOwner(null);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskReleasedEvent>(){}}).fire((Object)task);
        return null;
    }

    private boolean isAllowed(User user, List<String> groupIds, List<OrganizationalEntity> entities) {
        for (OrganizationalEntity entity : entities) {
            if (entity instanceof User && entity.equals(user)) {
                return true;
            }
            if (!(entity instanceof Group) || groupIds == null || !groupIds.contains(entity.getId())) continue;
            return true;
        }
        return false;
    }
}

