/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.api.TaskQueryService;
import org.jbpm.task.query.TaskSummary;

@Named
@Transactional
@ApplicationScoped
public class TaskQueryServiceImpl
implements TaskQueryService {
    @Inject
    private EntityManager em;

    @Override
    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        return this.em.createNamedQuery("TasksAssignedAsPotentialOwner").setParameter("userId", (Object)userId).setParameter("language", (Object)language).getResultList();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language) {
        return this.em.createNamedQuery("TasksAssignedAsPotentialOwnerWithGroups").setParameter("userId", (Object)userId).setParameter("groupIds", groupIds).setParameter("language", (Object)language).getResultList();
    }

    @Override
    public List<TaskSummary> getTasksAssignedByGroup(String groupId, String language) {
        return this.em.createNamedQuery("TasksAssignedAsPotentialOwnerByGroup").setParameter("groupId", (Object)groupId).setParameter("language", (Object)language).getResultList();
    }

    @Override
    public List<TaskSummary> getTasksAssignedByGroups(List<String> groupIds, String language) {
        List tasksByGroups = this.em.createNamedQuery("TasksAssignedAsPotentialOwnerByGroups").setParameter("groupIds", groupIds).getResultList();
        HashSet<Long> tasksIds = new HashSet<Long>();
        HashMap potentialOwners = new HashMap();
        for (Object o : tasksByGroups) {
            Object[] get = (Object[])o;
            tasksIds.add((Long)get[0]);
            if (potentialOwners.get((Long)get[0]) == null) {
                potentialOwners.put((Long)get[0], new ArrayList());
            }
            ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
        }
        if (!tasksIds.isEmpty()) {
            List tasks = this.em.createNamedQuery("TaskSummariesByIds").setParameter("taskIds", tasksIds).setParameter("language", (Object)language).getResultList();
            for (TaskSummary ts : tasks) {
                ts.setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
            return tasks;
        }
        return new ArrayList<TaskSummary>();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResult) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        return this.em.createNamedQuery("TasksAssignedAsRecipient").setParameter("userId", (Object)userId).setParameter("language", (Object)language).getResultList();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<TaskSummary> getTasksOwned(String userId) {
        List taskOwned = this.em.createNamedQuery("TasksOwned").setParameter("userId", (Object)userId).setParameter("language", (Object)"en-UK").getResultList();
        return taskOwned;
    }

    @Override
    public List<TaskSummary> getTasksOwned(String userId, List<Status> status, String language) {
        List taskOwned = this.em.createNamedQuery("TasksOwnedWithParticularStatus").setParameter("userId", (Object)userId).setParameter("status", status).setParameter("language", (Object)language).getResultList();
        if (!taskOwned.isEmpty()) {
            HashSet<Long> tasksIds = new HashSet<Long>();
            for (TaskSummary ts : taskOwned) {
                tasksIds.add(ts.getId());
            }
            List tasksPotentialOwners = this.em.createNamedQuery("TasksOwnedPotentialOwnersByTaskIds").setParameter("taskIds", tasksIds).getResultList();
            HashMap potentialOwners = new HashMap();
            for (Object o : tasksPotentialOwners) {
                Object[] get = (Object[])o;
                tasksIds.add((Long)get[0]);
                if (potentialOwners.get((Long)get[0]) == null) {
                    potentialOwners.put((Long)get[0], new ArrayList());
                }
                ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
            }
            for (TaskSummary ts : taskOwned) {
                ts.setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
        } else {
            return new ArrayList<TaskSummary>(0);
        }
        return taskOwned;
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, String language) {
        return this.em.createNamedQuery("TasksAssignedAsPotentialOwnerByStatus").setParameter("userId", (Object)userId).setParameter("language", (Object)language).setParameter("status", status).getResultList();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status, String language) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<TaskSummary> getSubTasksByParent(long parentId) {
        return this.em.createNamedQuery("GetSubTasksByParentTaskId").setParameter("parentId", (Object)parentId).setParameter("language", (Object)"en-UK").getResultList();
    }

    @Override
    public int getPendingSubTasksByParent(long parentId) {
        return this.em.createNamedQuery("GetSubTasksByParentTaskId").setParameter("parentId", (Object)parentId).setParameter("language", (Object)"en-UK").getResultList().size();
    }

    @Override
    public Task getTaskInstanceById(long taskId) {
        Task taskInstance = (Task)this.em.find(Task.class, (Object)taskId);
        return taskInstance;
    }

    @Override
    public Task getTaskByWorkItemId(long workItemId) {
        return (Task)this.em.createNamedQuery("TaskByWorkItemId").setParameter("workItemId", (Object)workItemId).setMaxResults(1).getResultList().get(0);
    }
}

