/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.drools.core.util.StringUtils;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Content;
import org.jbpm.task.ContentData;
import org.jbpm.task.Deadline;
import org.jbpm.task.Deadlines;
import org.jbpm.task.Escalation;
import org.jbpm.task.FaultData;
import org.jbpm.task.Group;
import org.jbpm.task.I18NText;
import org.jbpm.task.Notification;
import org.jbpm.task.Operation;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Reassignment;
import org.jbpm.task.Status;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.TaskDef;
import org.jbpm.task.User;
import org.jbpm.task.annotations.Mvel;
import org.jbpm.task.api.TaskDefService;
import org.jbpm.task.api.TaskInstanceService;
import org.jbpm.task.api.TaskQueryService;
import org.jbpm.task.exception.CannotAddTaskException;
import org.jbpm.task.identity.UserGroupCallback;
import org.jbpm.task.impl.factories.TaskFactory;
import org.jbpm.task.internals.lifecycle.LifeCycleManager;
import org.jbpm.task.internals.lifecycle.MVELLifeCycleManager;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.utils.ContentMarshallerHelper;

@Transactional
@ApplicationScoped
public class TaskInstanceServiceImpl
implements TaskInstanceService {
    @Inject
    private TaskDefService taskDefService;
    @Inject
    private TaskQueryService taskQueryService;
    @Inject
    @Mvel
    private LifeCycleManager lifeCycleManager;
    @Inject
    private EntityManager em;
    @Inject
    private Logger logger;
    @Inject
    private UserGroupCallback userGroupCallback;
    private Map<String, Boolean> userGroupsMap = new HashMap<String, Boolean>();

    public TaskInstanceServiceImpl() {
    }

    public TaskInstanceServiceImpl(TaskDefService taskDefService, LifeCycleManager lifeCycleManager) {
        this.taskDefService = taskDefService;
        this.lifeCycleManager = lifeCycleManager;
    }

    @Override
    public long newTask(String name, Map<String, Object> params) {
        TaskDef taskDef = this.taskDefService.getTaskDefById(name);
        Task task = TaskFactory.newTask(taskDef);
        this.em.persist((Object)task);
        if (params != null) {
            ContentData contentData = ContentMarshallerHelper.marshal(params, null);
            Content content = new Content(contentData.getContent());
            this.em.persist((Object)content);
            task.getTaskData().setDocument(content.getId(), contentData);
        }
        return task.getId();
    }

    @Override
    public long newTask(TaskDef taskDef, Map<String, Object> params) {
        return this.newTask(taskDef, params, true);
    }

    @Override
    public long newTask(TaskDef taskDef, Map<String, Object> params, boolean deploy) {
        if (deploy) {
            this.taskDefService.deployTaskDef(taskDef);
        }
        Task task = TaskFactory.newTask(taskDef);
        this.em.persist((Object)task);
        if (params != null) {
            ContentData contentData = ContentMarshallerHelper.marshal(params, null);
            Content content = new Content(contentData.getContent());
            this.em.persist((Object)content);
            task.getTaskData().setDocument(content.getId(), contentData);
        }
        return task.getId();
    }

    @Override
    public long addTask(Task task, Map<String, Object> params) {
        this.doCallbackOperationForPeopleAssignments(task.getPeopleAssignments());
        this.doCallbackOperationForTaskData(task.getTaskData());
        this.doCallbackOperationForTaskDeadlines(task.getDeadlines());
        if (params != null) {
            ContentData contentData = ContentMarshallerHelper.marshal(params, null);
            Content content = new Content(contentData.getContent());
            this.em.persist((Object)content);
            task.getTaskData().setDocument(content.getId(), contentData);
        }
        this.em.persist((Object)task);
        return task.getId();
    }

    @Override
    public long addTask(Task task, ContentData contentData) {
        this.doCallbackOperationForPeopleAssignments(task.getPeopleAssignments());
        this.doCallbackOperationForTaskData(task.getTaskData());
        this.doCallbackOperationForTaskDeadlines(task.getDeadlines());
        this.em.persist((Object)task);
        if (contentData != null) {
            Content content = new Content(contentData.getContent());
            this.em.persist((Object)content);
            task.getTaskData().setDocument(content.getId(), contentData);
        }
        return task.getId();
    }

    @Override
    public void activate(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Activate, taskId, userId, null, null, null);
    }

    @Override
    public void claim(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Claim, taskId, userId, null, null, null);
    }

    @Override
    public void claim(long taskId, String userId, List<String> groupIds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void claimNextAvailable(String userId, String language) {
        ArrayList<Status> status = new ArrayList<Status>();
        status.add(Status.Ready);
        List<TaskSummary> queryTasks = this.taskQueryService.getTasksAssignedAsPotentialOwnerByStatus(userId, status, language);
        if (queryTasks.size() > 0) {
            this.lifeCycleManager.taskOperation(Operation.Claim, queryTasks.get(0).getId(), userId, null, null, null);
        }
    }

    @Override
    public void claimNextAvailable(String userId, List<String> groupIds, String language) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void complete(long taskId, String userId, Map<String, Object> data) {
        this.lifeCycleManager.taskOperation(Operation.Complete, taskId, userId, null, data, null);
    }

    @Override
    public void delegate(long taskId, String userId, String targetUserId) {
        this.lifeCycleManager.taskOperation(Operation.Delegate, taskId, userId, targetUserId, null, null);
    }

    @Override
    public void deleteFault(long taskId, String userId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deleteOutput(long taskId, String userId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void exit(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Exit, taskId, userId, null, null, null);
    }

    @Override
    public void fail(long taskId, String userId, Map<String, Object> faultData) {
        this.lifeCycleManager.taskOperation(Operation.Fail, taskId, userId, null, faultData, null);
    }

    @Override
    public void forward(long taskId, String userId, String targetEntityId) {
        this.lifeCycleManager.taskOperation(Operation.Forward, taskId, userId, targetEntityId, null, null);
    }

    @Override
    public void release(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Release, taskId, userId, null, null, null);
    }

    @Override
    public void remove(long taskId, String userId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void resume(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Resume, taskId, userId, null, null, null);
    }

    @Override
    public void setFault(long taskId, String userId, FaultData fault) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setOutput(long taskId, String userId, Object outputContentData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPriority(long taskId, int priority) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        task.setPriority(priority);
    }

    @Override
    public void setTaskNames(long taskId, List<I18NText> taskNames) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        task.setNames(taskNames);
    }

    @Override
    public void skip(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Skip, taskId, userId, null, null, null);
    }

    @Override
    public void start(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Start, taskId, userId, null, null, null);
    }

    @Override
    public void stop(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Stop, taskId, userId, null, null, null);
    }

    @Override
    public void suspend(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Suspend, taskId, userId, null, null, null);
    }

    @Override
    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        this.doCallbackOperationForPotentialOwners(potentialOwners);
        ((MVELLifeCycleManager)this.lifeCycleManager).nominate(taskId, userId, potentialOwners);
    }

    @Override
    public void setSubTaskStrategy(long taskId, SubTasksStrategy strategy) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        task.setSubTaskStrategy(strategy);
    }

    @Override
    public void setExpirationDate(long taskId, Date date) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        task.getTaskData().setExpirationTime(date);
    }

    @Override
    public void setDescriptions(long taskId, List<I18NText> descriptions) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        task.setDescriptions(descriptions);
    }

    @Override
    public void setSkipable(long taskId, boolean skipable) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        task.getTaskData().setSkipable(skipable);
    }

    private List<String> doUserGroupCallbackOperation(String userId, List<String> groupIds) {
        this.doCallbackUserOperation(userId);
        this.doCallbackGroupsOperation(userId, groupIds);
        return this.userGroupCallback.getGroupsForUser(userId, groupIds, null);
    }

    private boolean doCallbackUserOperation(String userId) {
        if (userId != null && this.userGroupCallback.existsUser(userId)) {
            this.addUserFromCallbackOperation(userId);
            return true;
        }
        return false;
    }

    private boolean doCallbackGroupOperation(String groupId) {
        if (groupId != null && this.userGroupCallback.existsGroup(groupId)) {
            this.addGroupFromCallbackOperation(groupId);
            return true;
        }
        return false;
    }

    private void addUserFromCallbackOperation(String userId) {
        try {
            boolean userExists;
            boolean bl = userExists = this.em.find(User.class, (Object)userId) != null;
            if (!StringUtils.isEmpty((CharSequence)userId) && !userExists) {
                User user = new User(userId);
                this.em.persist((Object)user);
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "Unable to add user " + userId);
        }
    }

    private void doCallbackGroupsOperation(String userId, List<String> groupIds) {
        block6: {
            block4: {
                List<String> userGroups;
                block5: {
                    if (userId == null) break block4;
                    if (groupIds == null || groupIds.size() <= 0) break block5;
                    List<String> userGroups2 = this.userGroupCallback.getGroupsForUser(userId, groupIds, null);
                    for (String groupId : groupIds) {
                        if (!this.userGroupCallback.existsGroup(groupId) || userGroups2 == null || !userGroups2.contains(groupId)) continue;
                        this.addGroupFromCallbackOperation(groupId);
                    }
                    break block6;
                }
                if (this.userGroupsMap.containsKey(userId) && this.userGroupsMap.get(userId).booleanValue() || (userGroups = this.userGroupCallback.getGroupsForUser(userId, null, null)) == null || userGroups.size() <= 0) break block6;
                for (String group : userGroups) {
                    this.addGroupFromCallbackOperation(group);
                }
                this.userGroupsMap.put(userId, true);
                break block6;
            }
            if (groupIds != null) {
                for (String groupId : groupIds) {
                    this.addGroupFromCallbackOperation(groupId);
                }
            }
        }
    }

    private void addGroupFromCallbackOperation(String groupId) {
        try {
            boolean groupExists;
            boolean bl = groupExists = this.em.find(Group.class, (Object)groupId) != null;
            if (!StringUtils.isEmpty((CharSequence)groupId) && !groupExists) {
                Group group = new Group(groupId);
                this.em.persist((Object)group);
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "UserGroupCallback has not been registered.");
        }
    }

    private void doCallbackOperationForPeopleAssignments(PeopleAssignments assignments) {
        ArrayList<OrganizationalEntity> nonExistingEntities = new ArrayList<OrganizationalEntity>();
        if (assignments != null) {
            List<OrganizationalEntity> stakeholders;
            List<OrganizationalEntity> recipients;
            List<OrganizationalEntity> excludedOwners;
            List<OrganizationalEntity> businessAdmins = assignments.getBusinessAdministrators();
            if (businessAdmins != null) {
                for (OrganizationalEntity admin : businessAdmins) {
                    boolean groupExists;
                    boolean userExists;
                    if (admin instanceof User && !(userExists = this.doCallbackUserOperation(admin.getId()))) {
                        nonExistingEntities.add(admin);
                    }
                    if (!(admin instanceof Group) || (groupExists = this.doCallbackGroupOperation(admin.getId()))) continue;
                    nonExistingEntities.add(admin);
                }
                if (!nonExistingEntities.isEmpty()) {
                    businessAdmins.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if (businessAdmins == null || businessAdmins.isEmpty()) {
                throw new CannotAddTaskException("There are no known Business Administrators, task cannot be created according to WS-HT specification");
            }
            List<OrganizationalEntity> potentialOwners = assignments.getPotentialOwners();
            if (potentialOwners != null) {
                for (OrganizationalEntity powner : potentialOwners) {
                    boolean groupExists;
                    boolean userExists;
                    if (powner instanceof User && !(userExists = this.doCallbackUserOperation(powner.getId()))) {
                        nonExistingEntities.add(powner);
                    }
                    if (!(powner instanceof Group) || (groupExists = this.doCallbackGroupOperation(powner.getId()))) continue;
                    nonExistingEntities.add(powner);
                }
                if (!nonExistingEntities.isEmpty()) {
                    potentialOwners.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if (assignments.getTaskInitiator() != null && assignments.getTaskInitiator().getId() != null) {
                this.doCallbackUserOperation(assignments.getTaskInitiator().getId());
            }
            if ((excludedOwners = assignments.getExcludedOwners()) != null) {
                for (OrganizationalEntity exowner : excludedOwners) {
                    boolean groupExists;
                    boolean userExists;
                    if (exowner instanceof User && !(userExists = this.doCallbackUserOperation(exowner.getId()))) {
                        nonExistingEntities.add(exowner);
                    }
                    if (!(exowner instanceof Group) || (groupExists = this.doCallbackGroupOperation(exowner.getId()))) continue;
                    nonExistingEntities.add(exowner);
                }
                if (!nonExistingEntities.isEmpty()) {
                    excludedOwners.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if ((recipients = assignments.getRecipients()) != null) {
                for (OrganizationalEntity recipient : recipients) {
                    boolean groupExists;
                    boolean userExists;
                    if (recipient instanceof User && !(userExists = this.doCallbackUserOperation(recipient.getId()))) {
                        nonExistingEntities.add(recipient);
                    }
                    if (!(recipient instanceof Group) || (groupExists = this.doCallbackGroupOperation(recipient.getId()))) continue;
                    nonExistingEntities.add(recipient);
                }
                if (!nonExistingEntities.isEmpty()) {
                    recipients.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if ((stakeholders = assignments.getTaskStakeholders()) != null) {
                for (OrganizationalEntity stakeholder : stakeholders) {
                    boolean groupExists;
                    boolean userExists;
                    if (stakeholder instanceof User && !(userExists = this.doCallbackUserOperation(stakeholder.getId()))) {
                        nonExistingEntities.add(stakeholder);
                    }
                    if (!(stakeholder instanceof Group) || (groupExists = this.doCallbackGroupOperation(stakeholder.getId()))) continue;
                    nonExistingEntities.add(stakeholder);
                }
                if (!nonExistingEntities.isEmpty()) {
                    stakeholders.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
        }
    }

    private void doCallbackOperationForTaskDeadlines(Deadlines deadlines) {
        if (deadlines != null) {
            List<OrganizationalEntity> potentialOwners;
            List<OrganizationalEntity> administrators;
            List<OrganizationalEntity> recipients;
            List<Reassignment> ressignments;
            List<Notification> notifications;
            List<Escalation> escalations;
            if (deadlines.getStartDeadlines() != null) {
                List<Deadline> startDeadlines = deadlines.getStartDeadlines();
                for (Deadline startDeadline : startDeadlines) {
                    escalations = startDeadline.getEscalations();
                    if (escalations == null) continue;
                    for (Escalation escalation : escalations) {
                        notifications = escalation.getNotifications();
                        ressignments = escalation.getReassignments();
                        if (notifications != null) {
                            for (Notification notification : notifications) {
                                recipients = notification.getRecipients();
                                if (recipients != null) {
                                    for (OrganizationalEntity recipient : recipients) {
                                        if (recipient instanceof User) {
                                            this.doCallbackUserOperation(recipient.getId());
                                        }
                                        if (!(recipient instanceof Group)) continue;
                                        this.doCallbackGroupOperation(recipient.getId());
                                    }
                                }
                                if ((administrators = notification.getBusinessAdministrators()) == null) continue;
                                for (OrganizationalEntity administrator : administrators) {
                                    if (administrator instanceof User) {
                                        this.doCallbackUserOperation(administrator.getId());
                                    }
                                    if (!(administrator instanceof Group)) continue;
                                    this.doCallbackGroupOperation(administrator.getId());
                                }
                            }
                        }
                        if (ressignments == null) continue;
                        for (Reassignment reassignment : ressignments) {
                            potentialOwners = reassignment.getPotentialOwners();
                            if (potentialOwners == null) continue;
                            for (OrganizationalEntity potentialOwner : potentialOwners) {
                                if (potentialOwner instanceof User) {
                                    this.doCallbackUserOperation(potentialOwner.getId());
                                }
                                if (!(potentialOwner instanceof Group)) continue;
                                this.doCallbackGroupOperation(potentialOwner.getId());
                            }
                        }
                    }
                }
            }
            if (deadlines.getEndDeadlines() != null) {
                List<Deadline> endDeadlines = deadlines.getEndDeadlines();
                for (Deadline endDeadline : endDeadlines) {
                    escalations = endDeadline.getEscalations();
                    if (escalations == null) continue;
                    for (Escalation escalation : escalations) {
                        notifications = escalation.getNotifications();
                        ressignments = escalation.getReassignments();
                        if (notifications != null) {
                            for (Notification notification : notifications) {
                                recipients = notification.getRecipients();
                                if (recipients != null) {
                                    for (OrganizationalEntity recipient : recipients) {
                                        if (recipient instanceof User) {
                                            this.doCallbackUserOperation(recipient.getId());
                                        }
                                        if (!(recipient instanceof Group)) continue;
                                        this.doCallbackGroupOperation(recipient.getId());
                                    }
                                }
                                if ((administrators = notification.getBusinessAdministrators()) == null) continue;
                                for (OrganizationalEntity administrator : administrators) {
                                    if (administrator instanceof User) {
                                        this.doCallbackUserOperation(administrator.getId());
                                    }
                                    if (!(administrator instanceof Group)) continue;
                                    this.doCallbackGroupOperation(administrator.getId());
                                }
                            }
                        }
                        if (ressignments == null) continue;
                        for (Reassignment reassignment : ressignments) {
                            potentialOwners = reassignment.getPotentialOwners();
                            if (potentialOwners == null) continue;
                            for (OrganizationalEntity potentialOwner : potentialOwners) {
                                if (potentialOwner instanceof User) {
                                    this.doCallbackUserOperation(potentialOwner.getId());
                                }
                                if (!(potentialOwner instanceof Group)) continue;
                                this.doCallbackGroupOperation(potentialOwner.getId());
                            }
                        }
                    }
                }
            }
        }
    }

    private void doCallbackOperationForTaskData(TaskData data) {
        boolean userExists;
        if (data.getActualOwner() != null && !(userExists = this.doCallbackUserOperation(data.getActualOwner().getId()))) {
            data.setActualOwner(null);
            data.setStatus(Status.Ready);
        }
        if (data.getCreatedBy() != null && !(userExists = this.doCallbackUserOperation(data.getCreatedBy().getId()))) {
            data.setCreatedBy(null);
        }
    }

    private void doCallbackOperationForPotentialOwners(List<OrganizationalEntity> potentialOwners) {
        ArrayList<OrganizationalEntity> nonExistingEntities = new ArrayList<OrganizationalEntity>();
        for (OrganizationalEntity orgEntity : potentialOwners) {
            boolean groupExists;
            boolean userExists;
            if (orgEntity instanceof User && !(userExists = this.doCallbackUserOperation(orgEntity.getId()))) {
                nonExistingEntities.add(orgEntity);
            }
            if (!(orgEntity instanceof Group) || (groupExists = this.doCallbackGroupOperation(orgEntity.getId()))) continue;
            nonExistingEntities.add(orgEntity);
        }
        if (!nonExistingEntities.isEmpty()) {
            potentialOwners.removeAll(nonExistingEntities);
        }
    }

    @Override
    public int getPriority(long taskId) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        return task.getPriority();
    }

    @Override
    public Date getExpirationDate(long taskId) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        return task.getTaskData().getExpirationTime();
    }

    @Override
    public List<I18NText> getDescriptions(long taskId) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        return task.getDescriptions();
    }

    @Override
    public boolean isSkipable(long taskId) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        return task.getTaskData().isSkipable();
    }

    @Override
    public SubTasksStrategy getSubTaskStrategy(long taskId) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        return task.getSubTaskStrategy();
    }
}

