/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.lifecycle.listeners;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Task;
import org.jbpm.task.TaskEvent;
import org.jbpm.task.events.AfterTaskActivatedEvent;
import org.jbpm.task.events.AfterTaskAddedEvent;
import org.jbpm.task.events.AfterTaskClaimedEvent;
import org.jbpm.task.events.AfterTaskCompletedEvent;
import org.jbpm.task.events.AfterTaskExitedEvent;
import org.jbpm.task.events.AfterTaskFailedEvent;
import org.jbpm.task.events.AfterTaskStartedEvent;
import org.jbpm.task.events.AfterTaskStoppedEvent;
import org.jbpm.task.lifecycle.listeners.TaskLifeCycleEventListener;

@Alternative
@ApplicationScoped
public class JPATaskLifeCycleEventListener
implements TaskLifeCycleEventListener {
    @Inject
    private EntityManager em;

    @Override
    @Transactional
    public void afterTaskStartedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskStartedEvent Task ti) {
        this.em.persist((Object)new TaskEvent(ti.getId(), TaskEvent.TaskEventType.STARTED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskActivatedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskActivatedEvent Task ti) {
        this.em.persist((Object)new TaskEvent(ti.getId(), TaskEvent.TaskEventType.ACTIVATED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskClaimedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskClaimedEvent Task ti) {
        this.em.persist((Object)new TaskEvent(ti.getId(), TaskEvent.TaskEventType.CLAIMED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskSkippedEvent(Task ti) {
        this.em.persist((Object)new TaskEvent(ti.getId(), TaskEvent.TaskEventType.SKIPPED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskStoppedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskStoppedEvent Task ti) {
        this.em.persist((Object)new TaskEvent(ti.getId(), TaskEvent.TaskEventType.STOPPED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskCompletedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskCompletedEvent Task ti) {
        this.em.persist((Object)new TaskEvent(ti.getId(), TaskEvent.TaskEventType.COMPLETED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskFailedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskFailedEvent Task ti) {
        this.em.persist((Object)new TaskEvent(ti.getId(), TaskEvent.TaskEventType.FAILED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskAddedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskAddedEvent Task ti) {
        this.em.persist((Object)new TaskEvent(ti.getId(), TaskEvent.TaskEventType.ADDED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskExitedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskExitedEvent Task ti) {
        this.em.persist((Object)new TaskEvent(ti.getId(), TaskEvent.TaskEventType.EXITED, ti.getTaskData().getActualOwner()));
    }
}

