/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Content;
import org.jbpm.task.ContentData;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.deadlines.NotificationListener;
import org.jbpm.task.deadlines.notifications.impl.MockNotificationListener;
import org.jbpm.task.events.NotificationEvent;
import org.jbpm.task.impl.factories.TaskFactory;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class DeadlinesBaseTest
extends BaseTest {
    @Inject
    private NotificationListener notificationListener;

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        ((MockNotificationListener)this.notificationListener).reset();
    }

    @Test
    public void testDelayedEmailNotificationOnDeadline() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)new User("Tony Stark"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)new User("Darth Vader"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Tony Stark"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Darth Vader"), "en-UK");
        this.taskService.setUserInfo((UserInfo)userInfo);
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = TaskFactory.evalTask((Reader)reader, vars);
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Content content = new Content();
        Map<String, String> params = DeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentData marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        DeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)1L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Assert.assertEquals((long)2L, (long)((NotificationEvent)((MockNotificationListener)this.notificationListener).getEventsRecieved().get(0)).getNotification().getRecipients().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineContentSingleObject() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)new User("Tony Stark"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)new User("Darth Vader"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Tony Stark"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Darth Vader"), "en-UK");
        this.taskService.setUserInfo((UserInfo)userInfo);
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotificationContentSingleObject.mvel"));
        Task task = TaskFactory.evalTask((Reader)reader, vars);
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Content content = new Content();
        ContentData marshalledObject = ContentMarshallerHelper.marshal((Object)"'singleobject'", null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        Assert.assertEquals((Object)"'singleobject'", (Object)unmarshallObject.toString());
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)1L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskCompleted() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)new User("Tony Stark"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)new User("Darth Vader"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Tony Stark"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Darth Vader"), "en-UK");
        this.taskService.setUserInfo((UserInfo)userInfo);
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = TaskFactory.evalTask((Reader)reader, vars, (boolean)false);
        task.getTaskData().setSkipable(true);
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<User> ba = new ArrayList<User>();
        ba.add(new User("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<User> po = new ArrayList<User>();
        po.add(new User("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments(assignments);
        TaskFactory.initializeTask((Task)task);
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Content content = new Content();
        Map<String, String> params = DeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentData marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        DeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.start(taskId, "Administrator");
        this.taskService.complete(taskId, "Administrator", null);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Completed, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskFailed() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)new User("Tony Stark"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)new User("Darth Vader"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Tony Stark"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Darth Vader"), "en-UK");
        this.taskService.setUserInfo((UserInfo)userInfo);
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = TaskFactory.evalTask((Reader)reader, vars, (boolean)false);
        task.getTaskData().setSkipable(true);
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<User> ba = new ArrayList<User>();
        ba.add(new User("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<User> po = new ArrayList<User>();
        po.add(new User("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments(assignments);
        TaskFactory.initializeTask((Task)task);
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Content content = new Content();
        Map<String, String> params = DeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentData marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        DeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.start(taskId, "Administrator");
        this.taskService.fail(taskId, "Administrator", null);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Failed, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskSkipped() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)new User("Tony Stark"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)new User("Darth Vader"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Tony Stark"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Darth Vader"), "en-UK");
        this.taskService.setUserInfo((UserInfo)userInfo);
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = TaskFactory.evalTask((Reader)reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<User> ba = new ArrayList<User>();
        ba.add(new User("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<User> po = new ArrayList<User>();
        po.add(new User("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments(assignments);
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Content content = new Content();
        Map<String, String> params = DeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentData marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        DeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.skip(taskId, "Administrator");
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Obsolete, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskExited() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)new User("Tony Stark"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)new User("Darth Vader"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Tony Stark"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Darth Vader"), "en-UK");
        this.taskService.setUserInfo((UserInfo)userInfo);
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = TaskFactory.evalTask((Reader)reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<User> ba = new ArrayList<User>();
        ba.add(new User("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<User> po = new ArrayList<User>();
        po.add(new User("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments(assignments);
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Content content = new Content();
        Map<String, String> params = DeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentData marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        DeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.exit(taskId, "Administrator");
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedReassignmentOnDeadline() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)new User("Tony Stark"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)new User("Luke Cage"), "luke@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)new User("Bobba Fet"), "luke@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)new User("Jabba Hutt"), "luke@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Tony Stark"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Luke Cage"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Bobba Fet"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)new User("Jabba Hutt"), "en-UK");
        this.taskService.setUserInfo((UserInfo)userInfo);
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithReassignment.mvel"));
        Task task = TaskFactory.evalTask((Reader)reader, vars);
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        Thread.sleep(1000L);
        task = this.taskService.getTaskById(taskId);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ArrayList<String> ids = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        Assert.assertTrue((boolean)ids.contains("Tony Stark"));
        Assert.assertTrue((boolean)ids.contains("Luke Cage"));
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ids = new ArrayList(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        Assert.assertTrue((boolean)ids.contains("Bobba Fet"));
        Assert.assertTrue((boolean)ids.contains("Jabba Hutt"));
    }
}

