/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import org.jbpm.task.BooleanExpression;
import org.jbpm.task.Notification;
import org.jbpm.task.Reassignment;
import org.jbpm.task.utils.CollectionUtils;

@Entity
@SequenceGenerator(name="escalationIdSeq", sequenceName="ESCALATION_ID_SEQ", allocationSize=1)
public class Escalation
implements Externalizable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="escalationIdSeq")
    private long id;
    private String name;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Escalation_Constraints_Id", nullable=true)
    private List<BooleanExpression> constraints = Collections.emptyList();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Escalation_Notifications_Id", nullable=true)
    private List<Notification> notifications = Collections.emptyList();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Escalation_Reassignments_Id", nullable=true)
    private List<Reassignment> reassignments = Collections.emptyList();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        if (this.name != null) {
            out.writeBoolean(true);
            out.writeUTF(this.name);
        } else {
            out.writeBoolean(false);
        }
        CollectionUtils.writeBooleanExpressionList(this.constraints, out);
        CollectionUtils.writeNotificationList(this.notifications, out);
        CollectionUtils.writeReassignmentList(this.reassignments, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        if (in.readBoolean()) {
            this.name = in.readUTF();
        }
        this.constraints = CollectionUtils.readBooleanExpressionList(in);
        this.notifications = CollectionUtils.readNotificationList(in);
        this.reassignments = CollectionUtils.readReassignmentList(in);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<BooleanExpression> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<BooleanExpression> constraints) {
        this.constraints = constraints;
    }

    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<Notification> notifications) {
        this.notifications = notifications;
    }

    public List<Reassignment> getReassignments() {
        return this.reassignments;
    }

    public void setReassignments(List<Reassignment> reassignments) {
        this.reassignments = reassignments;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CollectionUtils.hashCode(this.constraints);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + CollectionUtils.hashCode(this.notifications);
        result = 31 * result + CollectionUtils.hashCode(this.reassignments);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Escalation)) {
            return false;
        }
        Escalation other = (Escalation)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return CollectionUtils.equals(this.constraints, other.constraints) && CollectionUtils.equals(this.notifications, other.notifications) && CollectionUtils.equals(this.reassignments, other.reassignments);
    }
}

