/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.impl;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Content;
import org.jbpm.task.ContentData;
import org.jbpm.task.Task;
import org.jbpm.task.api.TaskContentService;
import org.jbpm.task.utils.ContentMarshallerHelper;

@Transactional
@ApplicationScoped
public class TaskContentServiceImpl
implements TaskContentService {
    @Inject
    private EntityManager em;

    @Override
    public long addContent(long taskId, Map<String, Object> params) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        long outputContentId = task.getTaskData().getOutputContentId();
        Content outputContent = (Content)this.em.find(Content.class, (Object)outputContentId);
        long contentId = -1L;
        if (outputContent == null) {
            ContentData outputContentData = ContentMarshallerHelper.marshal(params, null);
            Content content = new Content(outputContentData.getContent());
            this.em.persist((Object)content);
            task.getTaskData().setOutput(content.getId(), outputContentData);
            contentId = content.getId();
        } else {
            Object unmarshalledObject = ContentMarshallerHelper.unmarshall(outputContent.getContent(), null);
            if (unmarshalledObject != null && unmarshalledObject instanceof Map) {
                ((Map)unmarshalledObject).putAll(params);
            }
            ContentData outputContentData = ContentMarshallerHelper.marshal(unmarshalledObject, null);
            outputContent.setContent(outputContentData.getContent());
            contentId = outputContentId;
        }
        return contentId;
    }

    @Override
    public long addContent(long taskId, Content content) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        this.em.persist((Object)content);
        task.getTaskData().setDocumentContentId(content.getId());
        return content.getId();
    }

    @Override
    public void deleteContent(long taskId, long contentId) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        task.getTaskData().setDocumentContentId(-1L);
        Content content = (Content)this.em.find(Content.class, (Object)contentId);
        this.em.remove((Object)content);
    }

    @Override
    public List<Content> getAllContentByTaskId(long taskId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Content getContentById(long contentId) {
        return (Content)this.em.find(Content.class, (Object)contentId);
    }
}

