/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.subtask;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.jbpm.task.ContentData;
import org.jbpm.task.FaultData;
import org.jbpm.task.I18NText;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.Task;
import org.jbpm.task.TaskDef;
import org.jbpm.task.api.TaskInstanceService;
import org.jbpm.task.api.TaskQueryService;
import org.jbpm.task.query.TaskSummary;

@Decorator
public class SubTaskDecorator
implements TaskInstanceService {
    @Inject
    @Delegate
    private TaskInstanceService instanceService;
    @Inject
    private EntityManager em;
    @Inject
    private TaskQueryService queryService;

    @Override
    public long newTask(String name, Map<String, Object> params) {
        return this.instanceService.newTask(name, params);
    }

    @Override
    public long newTask(TaskDef def, Map<String, Object> params) {
        return this.instanceService.newTask(def, params);
    }

    @Override
    public long newTask(TaskDef def, Map<String, Object> params, boolean deploy) {
        return this.instanceService.newTask(def, params, deploy);
    }

    @Override
    public long addTask(Task task, Map<String, Object> params) {
        return this.instanceService.addTask(task, params);
    }

    @Override
    public long addTask(Task task, ContentData data) {
        return this.instanceService.addTask(task, data);
    }

    @Override
    public void activate(long taskId, String userId) {
        this.instanceService.activate(taskId, userId);
    }

    @Override
    public void claim(long taskId, String userId) {
        this.instanceService.claim(taskId, userId);
    }

    @Override
    public void claim(long taskId, String userId, List<String> groupIds) {
        this.instanceService.claim(taskId, userId, groupIds);
    }

    @Override
    public void claimNextAvailable(String userId, String language) {
        this.instanceService.claimNextAvailable(userId, language);
    }

    @Override
    public void claimNextAvailable(String userId, List<String> groupIds, String language) {
        this.instanceService.claimNextAvailable(userId, groupIds, language);
    }

    @Override
    public void complete(long taskId, String userId, Map<String, Object> data) {
        this.instanceService.complete(taskId, userId, data);
        this.checkSubTaskStrategies(taskId, userId, data);
    }

    @Override
    public void delegate(long taskId, String userId, String targetUserId) {
        this.instanceService.delegate(taskId, userId, targetUserId);
    }

    @Override
    public void deleteFault(long taskId, String userId) {
        this.instanceService.deleteFault(taskId, userId);
    }

    @Override
    public void deleteOutput(long taskId, String userId) {
        this.instanceService.deleteOutput(taskId, userId);
    }

    @Override
    public void exit(long taskId, String userId) {
        this.instanceService.exit(taskId, userId);
    }

    @Override
    public void fail(long taskId, String userId, Map<String, Object> faultData) {
        this.instanceService.fail(taskId, userId, faultData);
    }

    @Override
    public void forward(long taskId, String userId, String targetEntityId) {
        this.instanceService.forward(taskId, userId, targetEntityId);
    }

    @Override
    public void release(long taskId, String userId) {
        this.instanceService.release(taskId, userId);
    }

    @Override
    public void remove(long taskId, String userId) {
        this.instanceService.remove(taskId, userId);
    }

    @Override
    public void resume(long taskId, String userId) {
        this.instanceService.resume(taskId, userId);
    }

    @Override
    public void setFault(long taskId, String userId, FaultData fault) {
        this.instanceService.setFault(taskId, userId, fault);
    }

    @Override
    public void setOutput(long taskId, String userId, Object outputContentData) {
        this.instanceService.setOutput(taskId, userId, outputContentData);
    }

    @Override
    public void setPriority(long taskId, int priority) {
        this.instanceService.setPriority(taskId, priority);
    }

    @Override
    public void skip(long taskId, String userId) {
        this.instanceService.skip(taskId, userId);
        this.checkSubTaskStrategies(taskId, userId, null);
    }

    @Override
    public void start(long taskId, String userId) {
        this.instanceService.start(taskId, userId);
    }

    @Override
    public void stop(long taskId, String userId) {
        this.instanceService.stop(taskId, userId);
    }

    @Override
    public void suspend(long taskId, String userId) {
        this.instanceService.suspend(taskId, userId);
    }

    @Override
    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        this.instanceService.nominate(taskId, userId, potentialOwners);
    }

    private void checkSubTaskStrategies(long taskId, String userId, Map<String, Object> data) {
        List<TaskSummary> subTasks;
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        Task parentTask = null;
        if (task.getTaskData().getParentId() != -1L) {
            parentTask = (Task)this.em.find(Task.class, (Object)task.getTaskData().getParentId());
        }
        if (parentTask != null && parentTask.getSubTaskStrategy().equals((Object)SubTasksStrategy.EndParentOnAllSubTasksEnd) && (subTasks = this.queryService.getSubTasksByParent(parentTask.getId())).isEmpty()) {
            this.complete(parentTask.getId(), "Administrator", data);
        }
        if (task.getSubTaskStrategy().equals((Object)SubTasksStrategy.SkipAllSubTasksOnParentSkip)) {
            subTasks = this.queryService.getSubTasksByParent(task.getId());
            for (TaskSummary taskSummary : subTasks) {
                Task subTask = this.queryService.getTaskInstanceById(taskSummary.getId());
                this.skip(subTask.getId(), "Administrator");
            }
        }
    }

    @Override
    public void setExpirationDate(long taskId, Date date) {
        this.instanceService.setExpirationDate(taskId, date);
    }

    @Override
    public void setDescriptions(long taskId, List<I18NText> descriptions) {
        this.instanceService.setDescriptions(taskId, descriptions);
    }

    @Override
    public void setSkipable(long taskId, boolean skipable) {
        this.instanceService.setSkipable(taskId, skipable);
    }

    @Override
    public void setSubTaskStrategy(long taskId, SubTasksStrategy strategy) {
        this.instanceService.setSubTaskStrategy(taskId, strategy);
    }

    @Override
    public int getPriority(long taskId) {
        return this.instanceService.getPriority(taskId);
    }

    @Override
    public Date getExpirationDate(long taskId) {
        return this.instanceService.getExpirationDate(taskId);
    }

    @Override
    public List<I18NText> getDescriptions(long taskId) {
        return this.instanceService.getDescriptions(taskId);
    }

    @Override
    public boolean isSkipable(long taskId) {
        return this.instanceService.isSkipable(taskId);
    }

    @Override
    public SubTasksStrategy getSubTaskStrategy(long taskId) {
        return this.instanceService.getSubTaskStrategy(taskId);
    }

    @Override
    public void setTaskNames(long taskId, List<I18NText> taskNames) {
        this.instanceService.setTaskNames(taskId, taskNames);
    }
}

