/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jbpm.services.task.HumanTaskServicesBaseTest;
import org.jbpm.services.task.deadlines.NotificationListener;
import org.jbpm.services.task.deadlines.notifications.impl.MockNotificationListener;
import org.jbpm.services.task.impl.factories.TaskFactory;
import org.jbpm.services.task.impl.model.ContentDataImpl;
import org.jbpm.services.task.impl.model.ContentImpl;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.task.api.model.Content;
import org.kie.internal.task.api.model.NotificationEvent;
import org.kie.internal.task.api.model.OrganizationalEntity;
import org.kie.internal.task.api.model.PeopleAssignments;
import org.kie.internal.task.api.model.Status;
import org.kie.internal.task.api.model.Task;

public abstract class DeadlinesBaseTest
extends HumanTaskServicesBaseTest {
    @Inject
    private NotificationListener notificationListener;

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        ((MockNotificationListener)this.notificationListener).reset();
    }

    @Test
    public void testDelayedEmailNotificationOnDeadline() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotification.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        Map<String, String> params = DeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        DeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)1L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Assert.assertEquals((long)2L, (long)((NotificationEvent)((MockNotificationListener)this.notificationListener).getEventsRecieved().get(0)).getNotification().getRecipients().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineContentSingleObject() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotificationContentSingleObject.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal((Object)"'singleobject'", null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        Assert.assertEquals((Object)"'singleobject'", (Object)unmarshallObject.toString());
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)1L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskCompleted() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotification.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignmentsImpl assignments = new PeopleAssignmentsImpl();
        ArrayList<UserImpl> ba = new ArrayList<UserImpl>();
        ba.add(new UserImpl("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<UserImpl> po = new ArrayList<UserImpl>();
        po.add(new UserImpl("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments((PeopleAssignments)assignments);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        Map<String, String> params = DeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        DeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.start(taskId, "Administrator");
        this.taskService.complete(taskId, "Administrator", null);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Completed, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskFailed() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotification.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignmentsImpl assignments = new PeopleAssignmentsImpl();
        ArrayList<UserImpl> ba = new ArrayList<UserImpl>();
        ba.add(new UserImpl("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<UserImpl> po = new ArrayList<UserImpl>();
        po.add(new UserImpl("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments((PeopleAssignments)assignments);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        Map<String, String> params = DeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        DeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.start(taskId, "Administrator");
        this.taskService.fail(taskId, "Administrator", null);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Failed, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskSkipped() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotification.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignmentsImpl assignments = new PeopleAssignmentsImpl();
        ArrayList<UserImpl> ba = new ArrayList<UserImpl>();
        ba.add(new UserImpl("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<UserImpl> po = new ArrayList<UserImpl>();
        po.add(new UserImpl("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments((PeopleAssignments)assignments);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        Map<String, String> params = DeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        DeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.skip(taskId, "Administrator");
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Obsolete, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskExited() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotification.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignmentsImpl assignments = new PeopleAssignmentsImpl();
        ArrayList<UserImpl> ba = new ArrayList<UserImpl>();
        ba.add(new UserImpl("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<UserImpl> po = new ArrayList<UserImpl>();
        po.add(new UserImpl("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments((PeopleAssignments)assignments);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        Map<String, String> params = DeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        DeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.exit(taskId, "Administrator");
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)((MockNotificationListener)this.notificationListener).getEventsRecieved().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedReassignmentOnDeadline() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithReassignment.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        Thread.sleep(1000L);
        task = this.taskService.getTaskById(taskId);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ArrayList<String> ids = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        Assert.assertTrue((boolean)ids.contains("Tony Stark"));
        Assert.assertTrue((boolean)ids.contains("Luke Cage"));
        for (long time = 0L; ((MockNotificationListener)this.notificationListener).getEventsRecieved().size() != 1 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ids = new ArrayList(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        Assert.assertTrue((boolean)ids.contains("Bobba Fet"));
        Assert.assertTrue((boolean)ids.contains("Jabba Hutt"));
    }
}

