/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jbpm.services.task.HumanTaskServicesBaseTest;
import org.jbpm.services.task.impl.factories.TaskFactory;
import org.jbpm.services.task.impl.model.ContentDataImpl;
import org.jbpm.services.task.impl.model.ContentImpl;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.task.api.model.Content;
import org.kie.internal.task.api.model.OrganizationalEntity;
import org.kie.internal.task.api.model.PeopleAssignments;
import org.kie.internal.task.api.model.Status;
import org.kie.internal.task.api.model.Task;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public abstract class EmailDeadlinesBaseTest
extends HumanTaskServicesBaseTest {
    private Wiser wiser;

    @Before
    public void setup() {
        super.setUp();
        Properties conf = new Properties();
        conf.setProperty("mail.smtp.host", "localhost");
        conf.setProperty("mail.smtp.port", "2345");
        conf.setProperty("mail.from", "from@domain.com");
        conf.setProperty("mail.replyto", "replyTo@domain.com");
        this.wiser = new Wiser();
        this.wiser.setHostname(conf.getProperty("mail.smtp.host"));
        this.wiser.setPort(Integer.parseInt(conf.getProperty("mail.smtp.port")));
        this.wiser.start();
    }

    @Override
    @After
    public void tearDown() {
        if (this.wiser != null) {
            this.wiser.stop();
        }
        super.tearDown();
    }

    protected Wiser getWiser() {
        return this.wiser;
    }

    @Test
    public void testDelayedEmailNotificationOnDeadline() throws Exception {
        WiserMessage msg2;
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotification.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        Map<String, String> params = EmailDeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        EmailDeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        for (WiserMessage msg2 : this.getWiser().getMessages()) {
            System.out.println(msg2.getEnvelopeReceiver());
        }
        Assert.assertEquals((long)2L, (long)this.getWiser().getMessages().size());
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(((WiserMessage)this.getWiser().getMessages().get(0)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.getWiser().getMessages().get(1)).getEnvelopeReceiver());
        Assert.assertTrue((boolean)list.contains("tony@domain.com"));
        Assert.assertTrue((boolean)list.contains("darth@domain.com"));
        msg2 = ((WiserMessage)this.getWiser().getMessages().get(0)).getMimeMessage();
        Assert.assertEquals((Object)"My Body", (Object)msg2.getContent());
        Assert.assertEquals((Object)"My Subject", (Object)msg2.getSubject());
        Assert.assertEquals((Object)"from@domain.com", (Object)((InternetAddress)msg2.getFrom()[0]).getAddress());
        Assert.assertEquals((Object)"replyTo@domain.com", (Object)((InternetAddress)msg2.getReplyTo()[0]).getAddress());
        Assert.assertEquals((Object)"tony@domain.com", (Object)((InternetAddress)msg2.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        Assert.assertEquals((Object)"darth@domain.com", (Object)((InternetAddress)msg2.getRecipients(MimeMessage.RecipientType.TO)[1]).getAddress());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineContentSingleObject() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotificationContentSingleObject.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal((Object)"'singleobject'", null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        Assert.assertEquals((Object)"'singleobject'", (Object)unmarshallObject.toString());
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        long time = 0L;
        while (this.getWiser().getMessages().size() != 2 && time < 5000L) {
            Thread.sleep(500L);
            time = 500L;
        }
        Assert.assertEquals((long)2L, (long)this.getWiser().getMessages().size());
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(((WiserMessage)this.getWiser().getMessages().get(0)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.getWiser().getMessages().get(1)).getEnvelopeReceiver());
        Assert.assertTrue((boolean)list.contains("tony@domain.com"));
        Assert.assertTrue((boolean)list.contains("darth@domain.com"));
        MimeMessage msg = ((WiserMessage)this.getWiser().getMessages().get(0)).getMimeMessage();
        Assert.assertEquals((Object)"'singleobject'", (Object)msg.getContent());
        Assert.assertEquals((Object)"'singleobject'", (Object)msg.getSubject());
        Assert.assertEquals((Object)"from@domain.com", (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        Assert.assertEquals((Object)"replyTo@domain.com", (Object)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        Assert.assertEquals((Object)"tony@domain.com", (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        Assert.assertEquals((Object)"darth@domain.com", (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[1]).getAddress());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskCompleted() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotification.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignmentsImpl assignments = new PeopleAssignmentsImpl();
        ArrayList<UserImpl> ba = new ArrayList<UserImpl>();
        ba.add(new UserImpl("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<UserImpl> po = new ArrayList<UserImpl>();
        po.add(new UserImpl("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments((PeopleAssignments)assignments);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        Map<String, String> params = EmailDeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        EmailDeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.start(taskId, "Administrator");
        this.taskService.complete(taskId, "Administrator", null);
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Completed, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskFailed() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotification.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignmentsImpl assignments = new PeopleAssignmentsImpl();
        ArrayList<UserImpl> ba = new ArrayList<UserImpl>();
        ba.add(new UserImpl("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<UserImpl> po = new ArrayList<UserImpl>();
        po.add(new UserImpl("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments((PeopleAssignments)assignments);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        Map<String, String> params = EmailDeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        EmailDeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.start(taskId, "Administrator");
        this.taskService.fail(taskId, "Administrator", null);
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Failed, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskSkipped() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotification.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignmentsImpl assignments = new PeopleAssignmentsImpl();
        ArrayList<UserImpl> ba = new ArrayList<UserImpl>();
        ba.add(new UserImpl("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<UserImpl> po = new ArrayList<UserImpl>();
        po.add(new UserImpl("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments((PeopleAssignments)assignments);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        Map<String, String> params = EmailDeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        EmailDeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.skip(taskId, "Administrator");
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Obsolete, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedEmailNotificationOnDeadlineTaskExited() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotification.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignmentsImpl assignments = new PeopleAssignmentsImpl();
        ArrayList<UserImpl> ba = new ArrayList<UserImpl>();
        ba.add(new UserImpl("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<UserImpl> po = new ArrayList<UserImpl>();
        po.add(new UserImpl("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments((PeopleAssignments)assignments);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        Map<String, String> params = EmailDeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        EmailDeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.exit(taskId, "Administrator");
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }

    @Test
    public void testDelayedReassignmentOnDeadline() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithReassignment.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        Thread.sleep(1000L);
        task = this.taskService.getTaskById(taskId);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ArrayList<String> ids = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        Assert.assertTrue((boolean)ids.contains("Tony Stark"));
        Assert.assertTrue((boolean)ids.contains("Luke Cage"));
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ids = new ArrayList(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        Assert.assertTrue((boolean)ids.contains("Bobba Fet"));
        Assert.assertTrue((boolean)ids.contains("Jabba Hutt"));
    }

    @Test
    public void testDelayedEmailNotificationStartDeadlineStatusDoesNotMatch() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithNotification.mvel"));
        TaskImpl task = TaskFactory.evalTask((Reader)reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignmentsImpl assignments = new PeopleAssignmentsImpl();
        ArrayList<UserImpl> ba = new ArrayList<UserImpl>();
        ba.add(new UserImpl("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<UserImpl> po = new ArrayList<UserImpl>();
        po.add(new UserImpl("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments((PeopleAssignments)assignments);
        this.taskService.addTask((Task)task, new HashMap());
        long taskId = task.getId();
        ContentImpl content = new ContentImpl();
        Map<String, String> params = EmailDeadlinesBaseTest.fillMarshalSubjectAndBodyParams();
        ContentDataImpl marshalledObject = ContentMarshallerHelper.marshal(params, null);
        content.setContent(marshalledObject.getContent());
        this.taskService.addContent(taskId, (Content)content);
        long contentId = content.getId();
        content = this.taskService.getContentById(contentId);
        Object unmarshallObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        EmailDeadlinesBaseTest.checkContentSubjectAndBody(unmarshallObject);
        this.taskService.start(taskId, "Administrator");
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 5000L; time += 500L) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)0L, (long)this.getWiser().getMessages().size());
        task = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)task.getDeadlines().getEndDeadlines().size());
    }
}

