/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jbpm.services.task.LifeCycleBaseTest;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.utils.MVELUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.kie.internal.task.api.TaskService;
import org.kie.internal.task.api.model.User;

public abstract class HumanTaskServicesBaseTest {
    protected static Logger logger;
    protected static boolean usersLoaded;
    @Inject
    protected TaskService taskService;
    protected static final String mySubject = "My Subject";
    protected static final String myBody = "My Body";

    @Before
    public void setUp() {
        if (!usersLoaded) {
            try {
                this.taskService.addUser((User)new UserImpl("Administrator"));
                usersLoaded = true;
            }
            catch (Exception ex) {
                Logger.getLogger(LifeCycleBaseTest.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @After
    public void tearDown() {
        int removeAllTasks = this.taskService.removeAllTasks();
    }

    @AfterClass
    public static void tearDownClass() {
        usersLoaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map fillUsersOrGroups(String mvelFileName) throws Exception {
        HashMap vars = new HashMap();
        Reader reader = null;
        Map result = null;
        try {
            reader = new InputStreamReader(HumanTaskServicesBaseTest.class.getResourceAsStream(mvelFileName));
            result = (Map)MVELUtils.eval((Reader)reader, vars);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return result;
    }

    protected static Map<String, String> fillMarshalSubjectAndBodyParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subject", mySubject);
        params.put("body", myBody);
        return params;
    }

    protected static void checkContentSubjectAndBody(Object unmarshalledObject) {
        Assert.assertTrue((String)"Content is null.", (unmarshalledObject != null && unmarshalledObject.toString() != null ? 1 : 0) != 0);
        String content = unmarshalledObject.toString();
        boolean match = false;
        if ("{body=My Body, subject=My Subject}".equals(content) || "{subject=My Subject, body=My Body}".equals(content)) {
            match = true;
        }
        Assert.assertTrue((String)"Content does not match.", (boolean)match);
    }

    protected void printTestName() {
        System.out.println("Running " + this.getClass().getSimpleName() + "." + Thread.currentThread().getStackTrace()[2].getMethodName());
    }

    static {
        usersLoaded = false;
    }
}

