/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jbpm.services.task.HumanTaskServicesBaseTest;
import org.jbpm.services.task.impl.factories.TaskFactory;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.internal.task.api.model.Status;
import org.kie.internal.task.api.model.Task;
import org.kie.internal.task.api.model.TaskSummary;

public abstract class TaskQueryServiceBaseTest
extends HumanTaskServicesBaseTest {
    @Test
    public void testGetTasksAssignedAsBusinessAdministratorWithUserLangNoTask() {
        List tasks = this.taskService.getTasksAssignedAsBusinessAdministrator("Bobba Fet", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsBusinessAdministratorWithUserLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        List tasks = this.taskService.getTasksAssignedAsBusinessAdministrator("Bobba Fet", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsExcludedOwnerWithUserLangNoTask() {
        List tasks = this.taskService.getTasksAssignedAsExcludedOwner("Bobba Fet", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsExcludedOwnerWithUserLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { excludedOwners = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        List tasks = this.taskService.getTasksAssignedAsExcludedOwner("Bobba Fet", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithUserLangNoTask() {
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Bobba Fet", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithUserLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Bobba Fet", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Bobba Fet", (Object)((TaskSummary)tasks.get(0)).getActualOwner().getId());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithUserGroupsLangNoTaskNoGroupIds() {
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Bobba Fet", groupIds, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithUserGroupsLangOneTaskOneUser() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Bobba Fet", groupIds, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Bobba Fet", (Object)((TaskSummary)tasks.get(0)).getActualOwner().getId());
    }

    @Ignore(value="requires fix - returns two tasks, only one should be returned")
    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithUserGroupsLangOneTaskOneGroup() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet'), new Group('Crusaders'), ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Bobba Fet", groupIds, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Darth Vader", (Object)((TaskSummary)tasks.get(0)).getActualOwner().getId());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithUserGroupsLangOffsetCountNoTask() {
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Bobba Fet", groupIds, "en-UK", 0, 1);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithUserGroupsLangOffsetCountTwoTasksOneMaxResult() {
        String str1 = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str1 = str1 + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str1 = str1 + "names = [ new I18NText( 'en-UK', 'First task')] })";
        String str2 = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str2 = str2 + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str2 = str2 + "names = [ new I18NText( 'en-UK', 'Second task')] })";
        TaskImpl task1 = TaskFactory.evalTask((Reader)new StringReader(str1));
        this.taskService.addTask((Task)task1, new HashMap());
        TaskImpl task2 = TaskFactory.evalTask((Reader)new StringReader(str2));
        this.taskService.addTask((Task)task2, new HashMap());
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Bobba Fet", groupIds, "en-UK", 0, 1);
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithUserGroupsLangOffsetCountTwoTasksTwoMaxResults() {
        String str1 = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str1 = str1 + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str1 = str1 + "names = [ new I18NText( 'en-UK', 'First task')] })";
        String str2 = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str2 = str2 + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str2 = str2 + "names = [ new I18NText( 'en-UK', 'Second task')] })";
        TaskImpl task1 = TaskFactory.evalTask((Reader)new StringReader(str1));
        this.taskService.addTask((Task)task1, new HashMap());
        TaskImpl task2 = TaskFactory.evalTask((Reader)new StringReader(str2));
        this.taskService.addTask((Task)task2, new HashMap());
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Bobba Fet", groupIds, "en-UK", 0, 2);
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithUserGroupsLangOffsetCountTwoTasksOneOffsetOneMaxResult() {
        String str1 = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str1 = str1 + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str1 = str1 + "names = [ new I18NText( 'en-UK', 'First task')] })";
        String str2 = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str2 = str2 + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str2 = str2 + "names = [ new I18NText( 'en-UK', 'Second task')] })";
        TaskImpl task1 = TaskFactory.evalTask((Reader)new StringReader(str1));
        this.taskService.addTask((Task)task1, new HashMap());
        TaskImpl task2 = TaskFactory.evalTask((Reader)new StringReader(str2));
        this.taskService.addTask((Task)task2, new HashMap());
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Bobba Fet", groupIds, "en-UK", 1, 1);
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerByStatusWithUserStatusLangNoTask() {
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Created);
        statuses.add(Status.Ready);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwnerByStatus("Bobba Fet", statuses, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerByStatusWithUserStatusLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Created);
        statuses.add(Status.Ready);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwnerByStatus("Bobba Fet", statuses, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerByStatusWithUserStatusLangOneTaskReserved() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwnerByStatus("Bobba Fet", statuses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Bobba Fet", (Object)((TaskSummary)tasks.get(0)).getActualOwner().getId());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerByStatusByGroupWithUserStatusLangNoTask() {
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Created);
        statuses.add(Status.Ready);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwnerByStatusByGroup("Bobba Fet", groupIds, statuses, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerByStatusByGroupWithUserStatusLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Created);
        statuses.add(Status.Ready);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwnerByStatusByGroup("Bobba Fet", groupIds, statuses, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerByStatusByGroupWithUserStatusLangOneTaskReserved() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet') ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwnerByStatusByGroup("Bobba Fet", groupIds, statuses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Bobba Fet", (Object)((TaskSummary)tasks.get(0)).getActualOwner().getId());
    }

    @Test
    public void testGetTasksAssignedAsRecipientWithUserLangNoTask() {
        List tasks = this.taskService.getTasksAssignedAsRecipient("Bobba Fet", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsRecipientWithUserLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { recipients = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        List tasks = this.taskService.getTasksAssignedAsRecipient("Bobba Fet", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsTaskInitiatorWithUserLangNoTask() {
        List tasks = this.taskService.getTasksAssignedAsTaskInitiator("Bobba Fet", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsTaskInitiatorWithUserLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { taskInitiator = new User('Bobba Fet'), }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        List tasks = this.taskService.getTasksAssignedAsTaskInitiator("Bobba Fet", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsTaskStakeholderWithUserLangNoTask() {
        List tasks = this.taskService.getTasksAssignedAsTaskStakeholder("Bobba Fet", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedAsTaskStakeholderWithUserLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { taskStakeholders = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        List tasks = this.taskService.getTasksAssignedAsTaskStakeholder("Bobba Fet", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedByGroupWithGroupLangNoTask() {
        List tasks = this.taskService.getTasksAssignedByGroup("Crusaders", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedByGroupWithGroupLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Crusaders')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        List tasks = this.taskService.getTasksAssignedByGroup("Crusaders", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedByGroupsWithGroupsLangNoTask() {
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.taskService.getTasksAssignedByGroups(groupIds, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedByGroupsWithGroupsLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Crusaders')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.taskService.getTasksAssignedByGroups(groupIds, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedByGroupsByExpirationDateWithGroupsLangDateNoTask() {
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        Date date = new Date();
        List tasks = this.taskService.getTasksAssignedByGroupsByExpirationDate(groupIds, "en-UK", date);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedByGroupsByExpirationDateWithUserStatusDateOneTaskReserved() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { expirationTime = new Date( 10000000 ), } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Crusaders')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        Date date = new Date(10000000L);
        List tasks = this.taskService.getTasksAssignedByGroupsByExpirationDate(groupIds, "en-UK", date);
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksOwnedWithUserNoTask() {
        List tasks = this.taskService.getTasksOwned("Bobba Fet");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksOwnedWithUserOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        List tasks = this.taskService.getTasksOwned("Bobba Fet");
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Bobba Fet", (Object)((TaskSummary)tasks.get(0)).getActualOwner().getId());
    }

    @Test
    public void testGetTasksOwnedWithUserStatusLangNoTask() {
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Created);
        statuses.add(Status.Ready);
        List tasks = this.taskService.getTasksOwned("Darth Vader", statuses, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksOwnedWithUserStatusLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List tasks = this.taskService.getTasksOwned("Bobba Fet", statuses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Bobba Fet", (Object)((TaskSummary)tasks.get(0)).getActualOwner().getId());
    }

    @Test
    public void testGetTasksOwnedWithUserStatusLangOneTaskCompleted() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Completed);
        List tasks = this.taskService.getTasksOwned("Bobba Fet", statuses, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksOwnedByExpirationDateWithUserStatusDateNoTask() {
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Created);
        statuses.add(Status.Ready);
        Date date = new Date();
        List tasks = this.taskService.getTasksOwnedByExpirationDate("Darth Vader", statuses, date);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetTasksOwnedByExpirationDateWithUserStatusDateOneTaskReserved() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { expirationTime = new Date( 10000000 ), } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        Date date = new Date(10000000L);
        List tasks = this.taskService.getTasksOwnedByExpirationDate("Bobba Fet", statuses, date);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Bobba Fet", (Object)((TaskSummary)tasks.get(0)).getActualOwner().getId());
    }

    @Test
    public void testGetTasksOwnedByExpirationDateWithUserStatusDateOneTaskCompleted() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { expirationTime = new Date( 10000000 ), } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Completed);
        Date date = new Date(10000000L);
        List tasks = this.taskService.getTasksOwnedByExpirationDate("Bobba Fet", statuses, date);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Ignore(value="not familiar with sub task concept; groupIds is not supplied to corresponding query")
    @Test
    public void testGetSubTasksAssignedAsPotentialOwnerWithParentUserLangNoTask() {
        List tasks = this.taskService.getSubTasksAssignedAsPotentialOwner(0L, "Bobba Fet", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Ignore(value="not familiar with sub task concept")
    @Test
    public void testGetSubTasksAssignedAsPotentialOwnerWithParentUserLangOneTask() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { taskStakeholders = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        List tasks = this.taskService.getSubTasksAssignedAsPotentialOwner(0L, "Bobba Fet", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetSubTasksByParentWithParentNoTask() {
        List tasks = this.taskService.getSubTasksByParent(0L);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testGetPendingSubTasksByParentWithParentNoTask() {
        int count = this.taskService.getPendingSubTasksByParent(0L);
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testGetTaskByWorkItemIdWithWorkItemNoTask() {
        Task task = this.taskService.getTaskByWorkItemId(0L);
        Assert.assertEquals(null, (Object)task);
    }

    @Test
    public void testGetTaskInstanceByIdWithWorkItemNoTask() {
        Task task = this.taskService.getTaskByWorkItemId(0L);
        Assert.assertEquals(null, (Object)task);
    }

    @Test
    public void testGetTasksAssignedByExpirationDateOptional() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.InProgress);
        statuses.add(Status.Reserved);
        statuses.add(Status.Created);
        List tasks = this.taskService.getTasksOwnedByExpirationDateOptional("Bobba Fet", statuses, new Date());
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksAssignedByGroupsByExpirationDateOptional() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Crusaders')  ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.taskService.getTasksAssignedByGroupsByExpirationDateOptional(groupIds, "en-UK", new Date());
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksByProcessInstanceId() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {processInstanceId = 99 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {processInstanceId = 100 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'Another name')] })";
        task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        List tasks = this.taskService.getTasksByProcessInstanceId(99L);
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksByStatusByProcessId() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {processInstanceId = 99 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {processInstanceId = 100 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'Another name')] })";
        task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List tasks = this.taskService.getTasksByStatusByProcessId(99L, statuses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testGetTasksByStatusByProcessIdByTaskName() {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {processInstanceId = 99 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {processInstanceId = 100 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'Another name')] })";
        task = TaskFactory.evalTask((Reader)new StringReader(str));
        this.taskService.addTask((Task)task, new HashMap());
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List tasks = this.taskService.getTasksByStatusByProcessIdByTaskName(99L, statuses, "This is my task name", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
    }
}

